/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.support.Person;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.serde.JsonSchemaKafkaDeserializer;
import io.apicurio.registry.utils.serde.JsonSchemaKafkaSerializer;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.SimpleTopicIdStrategy;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.InputStream;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.jupiter.api.Assertions;

@QuarkusTest
public class JsonSerdeTest
extends AbstractResourceTestBase {
    @RegistryServiceTest
    public void testSchema(Supplier<RegistryService> supplier) throws Exception {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String artifactId = this.generateArtifactId();
        CompletionStage cs = supplier.get().createArtifact(ArtifactType.JSON, artifactId, null, jsonSchema);
        ArtifactMetaData amd = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)cs);
        supplier.get().reset();
        TestUtils.retry(() -> ((RegistryService)supplier.get()).getArtifactByGlobalId(amd.getGlobalId().longValue()));
        Person person = new Person("Ales", "Justin", 23);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(supplier.get(), Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(supplier.get(), Boolean.valueOf(true));){
            serializer.setArtifactIdStrategy((ArtifactIdStrategy)new SimpleTopicIdStrategy());
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            person = (Person)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Ales", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Justin", (Object)person.getLastName());
            Assertions.assertEquals((int)23, (int)person.getAge());
            person.setAge(-1);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)person);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializer.setValidationEnabled(false);
            bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            try {
                deserializer.deserialize(artifactId, (Headers)headers, bytes);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

