/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SearchedArtifact;
import io.apicurio.registry.rest.beans.SearchedVersion;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;

@QuarkusTest
public class RegistryClientTest
extends AbstractResourceTestBase {
    @RegistryServiceTest
    public void testSmoke(Supplier<RegistryService> supplier) {
        RegistryService service = supplier.get();
        service.deleteAllGlobalRules();
        Assertions.assertNotNull((Object)service.toString());
        Assertions.assertEquals((int)service.hashCode(), (int)service.hashCode());
        Assertions.assertEquals((Object)service, (Object)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RegistryServiceTest
    public void testAsyncCRUD(Supplier<RegistryService> supplier) throws Exception {
        String artifactId = this.generateArtifactId();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream("{\"name\":\"redhat\"}".getBytes(StandardCharsets.UTF_8));
            CompletionStage csResult = supplier.get().createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)stream);
            ConcurrentUtil.result((CompletionStage)csResult);
            EditableMetaData emd = new EditableMetaData();
            emd.setName("myname");
            supplier.get().updateArtifactMetaData(artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = ((RegistryService)supplier.get()).getArtifactMetaData(artifactId);
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"myname", (Object)artifactMetaData.getName());
            });
            stream = new ByteArrayInputStream("{\"name\":\"ibm\"}".getBytes(StandardCharsets.UTF_8));
            csResult = supplier.get().updateArtifact(artifactId, ArtifactType.JSON, (InputStream)stream);
            ConcurrentUtil.result((CompletionStage)csResult);
        }
        finally {
            supplier.get().deleteArtifact(artifactId);
        }
    }

    @RegistryServiceTest
    void testSearchArtifact(Supplier<RegistryService> supplier) throws Exception {
        RegistryService client = supplier.get();
        client.listArtifacts();
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        ByteArrayInputStream artifactData = new ByteArrayInputStream(("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
        CompletionStage cs = client.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)artifactData);
        long id = ((ArtifactMetaData)ConcurrentUtil.result((CompletionStage)cs)).getGlobalId();
        TestUtils.retry(() -> {
            ArtifactMetaData artifactMetaData = client.getArtifactMetaDataByGlobalId(id);
            Assertions.assertNotNull((Object)artifactMetaData);
        });
        ArtifactSearchResults results = client.searchArtifacts(name, Integer.valueOf(0), Integer.valueOf(2), SearchOver.name, SortOrder.asc);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)1, (Integer)results.getCount());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)name, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getName());
    }

    @RegistryServiceTest
    void testSearchVersion(Supplier<RegistryService> supplier) throws Exception {
        RegistryService client = supplier.get();
        client.listArtifacts();
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        ByteArrayInputStream artifactData = new ByteArrayInputStream(("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
        CompletionStage amd = client.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)artifactData);
        long id1 = ((ArtifactMetaData)ConcurrentUtil.result((CompletionStage)amd)).getGlobalId();
        TestUtils.retry(() -> {
            ArtifactMetaData artifactMetaData = client.getArtifactMetaDataByGlobalId(id1);
            Assertions.assertNotNull((Object)artifactMetaData);
        });
        artifactData.reset();
        CompletionStage vmd = client.createArtifactVersion(artifactId, ArtifactType.JSON, (InputStream)artifactData);
        long id2 = ((VersionMetaData)ConcurrentUtil.result((CompletionStage)vmd)).getGlobalId();
        TestUtils.retry(() -> {
            ArtifactMetaData artifactMetaData = client.getArtifactMetaDataByGlobalId(id2);
            Assertions.assertNotNull((Object)artifactMetaData);
        });
        VersionSearchResults results = client.searchVersions(artifactId, Integer.valueOf(0), Integer.valueOf(2));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)2, (Integer)results.getCount());
        Assertions.assertEquals((int)2, (int)results.getVersions().size());
        Assertions.assertEquals((Object)name, (Object)((SearchedVersion)results.getVersions().get(0)).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RegistryServiceTest
    public void testLabels(Supplier<RegistryService> supplier) throws Exception {
        String artifactId = this.generateArtifactId();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream("{\"name\":\"redhat\"}".getBytes(StandardCharsets.UTF_8));
            CompletionStage csResult = supplier.get().createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)stream);
            ConcurrentUtil.result((CompletionStage)csResult);
            EditableMetaData emd = new EditableMetaData();
            emd.setName("myname");
            List<String> artifactLabels = Arrays.asList("Open Api", "Awesome Artifact", "JSON");
            emd.setLabels(artifactLabels);
            supplier.get().updateArtifactMetaData(artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = ((RegistryService)supplier.get()).getArtifactMetaData(artifactId);
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"myname", (Object)artifactMetaData.getName());
                Assertions.assertEquals((int)3, (int)artifactMetaData.getLabels().size());
                Assertions.assertTrue((boolean)artifactMetaData.getLabels().containsAll(artifactLabels));
            });
            TestUtils.retry(() -> {
                ArtifactSearchResults results = ((RegistryService)supplier.get()).searchArtifacts("Open Api", Integer.valueOf(0), Integer.valueOf(2), SearchOver.labels, SortOrder.asc);
                Assertions.assertNotNull((Object)results);
                Assertions.assertEquals((int)1, (Integer)results.getCount());
                Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
                Assertions.assertTrue((boolean)((SearchedArtifact)results.getArtifacts().get(0)).getLabels().containsAll(artifactLabels));
            });
        }
        finally {
            supplier.get().deleteArtifact(artifactId);
        }
    }
}

