/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.support.TestCmmn;
import io.apicurio.registry.support.Tester;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.serde.AvroKafkaDeserializer;
import io.apicurio.registry.utils.serde.AvroKafkaSerializer;
import io.apicurio.registry.utils.serde.ProtobufKafkaDeserializer;
import io.apicurio.registry.utils.serde.ProtobufKafkaSerializer;
import io.apicurio.registry.utils.serde.avro.AvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.ReflectAvroDatumProvider;
import io.apicurio.registry.utils.serde.strategy.AutoRegisterIdStrategy;
import io.apicurio.registry.utils.serde.strategy.CachedSchemaIdStrategy;
import io.apicurio.registry.utils.serde.strategy.FindBySchemaIdStrategy;
import io.apicurio.registry.utils.serde.strategy.FindLatestIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GetOrCreateIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import io.apicurio.registry.utils.serde.strategy.TopicRecordIdStrategy;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;

@QuarkusTest
public class RegistrySerdeTest
extends AbstractResourceTestBase {
    @RegistryServiceTest
    public void testFindBySchema(Supplier<RegistryService> supplier) throws Exception {
        String artifactId = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        CompletionStage csa = supplier.get().createArtifact(ArtifactType.AVRO, artifactId, null, (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        ArtifactMetaData amd = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)csa);
        TestUtils.retry(() -> ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(amd.getGlobalId().longValue()));
        Assertions.assertNotNull((Object)supplier.get().getArtifactMetaDataByGlobalId(amd.getGlobalId().longValue()));
        FindBySchemaIdStrategy idStrategy = new FindBySchemaIdStrategy();
        Assertions.assertEquals((Long)amd.getGlobalId(), (long)idStrategy.findId(supplier.get(), artifactId, ArtifactType.AVRO, (Object)schema));
    }

    @RegistryServiceTest
    public void testGetOrCreate(Supplier<RegistryService> supplier) throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        String artifactId = this.generateArtifactId();
        CompletionStage csa = supplier.get().createArtifact(ArtifactType.AVRO, artifactId, null, (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        ArtifactMetaData amd = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)csa);
        TestUtils.retry(() -> ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(amd.getGlobalId().longValue()));
        Assertions.assertNotNull((Object)supplier.get().getArtifactMetaDataByGlobalId(amd.getGlobalId().longValue()));
        GetOrCreateIdStrategy idStrategy = new GetOrCreateIdStrategy();
        Assertions.assertEquals((Long)amd.getGlobalId(), (long)idStrategy.findId(supplier.get(), artifactId, ArtifactType.AVRO, (Object)schema));
        artifactId = this.generateArtifactId();
        long id = idStrategy.findId(supplier.get(), artifactId, ArtifactType.AVRO, (Object)schema);
        TestUtils.retry(() -> ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(id));
        Assertions.assertEquals((long)id, (long)idStrategy.findId(supplier.get(), artifactId, ArtifactType.AVRO, (Object)schema));
    }

    @RegistryServiceTest
    public void testCachedSchema(Supplier<RegistryService> supplier) throws Exception {
        RegistryService service = supplier.get();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord5x\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        String artifactId = this.generateArtifactId();
        CachedSchemaIdStrategy idStrategy = new CachedSchemaIdStrategy();
        long id = idStrategy.findId(service, artifactId, ArtifactType.AVRO, (Object)schema);
        service.reset();
        TestUtils.retry(() -> service.getArtifactMetaDataByGlobalId(id));
        Assertions.assertEquals((long)id, (long)idStrategy.findId(service, artifactId, ArtifactType.AVRO, (Object)schema));
    }

    @RegistryServiceTest
    public void testConfiguration(Supplier<RegistryService> supplier) throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        String artifactId = this.generateArtifactId();
        CompletionStage csa = supplier.get().createArtifact(ArtifactType.AVRO, artifactId + "-myrecord3", null, (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        ArtifactMetaData amd = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)csa);
        supplier.get().reset();
        ArtifactMetaData amdById = (ArtifactMetaData)TestUtils.retry(() -> ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(amd.getGlobalId().longValue()));
        Assertions.assertNotNull((Object)amdById);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("bar", (Object)"somebar");
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("apicurio.registry.url", "http://localhost:8081/api");
        config.put("apicurio.registry.artifact-id", new TopicRecordIdStrategy());
        config.put("apicurio.registry.global-id", new FindLatestIdStrategy());
        config.put("apicurio.registry.avro-datum-provider", new DefaultAvroDatumProvider());
        Serializer serializer = (Serializer)this.getClass().getClassLoader().loadClass(AvroKafkaSerializer.class.getName()).newInstance();
        serializer.configure(config, true);
        byte[] bytes = serializer.serialize(artifactId, (Object)record);
        Deserializer deserializer = (Deserializer)this.getClass().getClassLoader().loadClass(AvroKafkaDeserializer.class.getName()).newInstance();
        deserializer.configure(config, true);
        record = (GenericData.Record)deserializer.deserialize(artifactId, bytes);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
        config.put("apicurio.registry.artifact-id", TopicRecordIdStrategy.class);
        config.put("apicurio.registry.global-id", FindLatestIdStrategy.class);
        config.put("apicurio.registry.avro-datum-provider", DefaultAvroDatumProvider.class);
        serializer.configure(config, true);
        bytes = serializer.serialize(artifactId, (Object)record);
        deserializer.configure(config, true);
        record = (GenericData.Record)deserializer.deserialize(artifactId, bytes);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
        config.put("apicurio.registry.artifact-id", TopicRecordIdStrategy.class.getName());
        config.put("apicurio.registry.global-id", FindLatestIdStrategy.class.getName());
        config.put("apicurio.registry.avro-datum-provider", DefaultAvroDatumProvider.class.getName());
        serializer.configure(config, true);
        bytes = serializer.serialize(artifactId, (Object)record);
        deserializer.configure(config, true);
        record = (GenericData.Record)deserializer.deserialize(artifactId, bytes);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
        serializer.close();
        deserializer.close();
    }

    @RegistryServiceTest
    public void testAvro(Supplier<RegistryService> supplier) throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(supplier.get());
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(supplier.get());){
            serializer.setGlobalIdStrategy((GlobalIdStrategy)new AutoRegisterIdStrategy());
            GenericData.Record record = new GenericData.Record(schema);
            record.put("bar", (Object)"somebar");
            String subject = this.generateArtifactId();
            byte[] bytes = serializer.serialize(subject, (Object)record);
            TestUtils.waitForSchema((RegistryService)supplier.get(), (byte[])bytes);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @RegistryServiceTest
    public void testAvroReflect(Supplier<RegistryService> supplier) throws Exception {
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(supplier.get());
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(supplier.get());){
            serializer.setGlobalIdStrategy((GlobalIdStrategy)new AutoRegisterIdStrategy());
            serializer.setAvroDatumProvider((AvroDatumProvider)new ReflectAvroDatumProvider());
            deserializer.setAvroDatumProvider((AvroDatumProvider)new ReflectAvroDatumProvider());
            String artifactId = this.generateArtifactId();
            Tester tester = new Tester("Apicurio");
            byte[] bytes = serializer.serialize(artifactId, (Object)tester);
            TestUtils.waitForSchema((RegistryService)supplier.get(), (byte[])bytes);
            tester = (Tester)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)"Apicurio", (Object)tester.getName());
        }
    }

    @RegistryServiceTest
    public void testProto(Supplier<RegistryService> supplier) throws Exception {
        try (ProtobufKafkaSerializer serializer = new ProtobufKafkaSerializer(supplier.get());
             ProtobufKafkaDeserializer deserializer = new ProtobufKafkaDeserializer(supplier.get());){
            serializer.setGlobalIdStrategy((GlobalIdStrategy)new AutoRegisterIdStrategy());
            TestCmmn.UUID record = TestCmmn.UUID.newBuilder().setLsb(2L).setMsb(1L).build();
            String subject = this.generateArtifactId();
            byte[] bytes = serializer.serialize(subject, (Object)record);
            TestUtils.waitForSchema((RegistryService)supplier.get(), (byte[])bytes);
            DynamicMessage dm = (DynamicMessage)deserializer.deserialize(subject, bytes);
            Descriptors.Descriptor descriptor = dm.getDescriptorForType();
            Descriptors.FieldDescriptor lsb = descriptor.findFieldByName("lsb");
            Assertions.assertNotNull((Object)lsb);
            Assertions.assertEquals((Object)2L, (Object)dm.getField(lsb));
            Descriptors.FieldDescriptor msb = descriptor.findFieldByName("msb");
            Assertions.assertNotNull((Object)msb);
            Assertions.assertEquals((Object)1L, (Object)dm.getField(msb));
        }
    }
}

