/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.types.RuleType;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RulesResourceTest
extends AbstractResourceTestBase {
    @Test
    public void testGlobalRulesEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/rules", new Object[0])).then()).statusCode(200)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testGlobalRules() {
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A rule named 'VALIDITY' already exists."), new Object[0]);
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("compatibility-config");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"compatibility-config"), new Object[0]);
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("updated-configuration");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).put("/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"updated-configuration"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"updated-configuration"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/rules/COMPATIBILITY", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/COMPATIBILITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'COMPATIBILITY' was found."), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", Matchers.nullValue(), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/rules", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/VALIDITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'VALIDITY' was found."), new Object[0]);
    }

    @Test
    public void testDeleteAllGlobalRules() {
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/rules", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/rules/VALIDITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'VALIDITY' was found."), new Object[0]);
    }
}

