/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AvroKafkaDeserializer;
import io.apicurio.registry.utils.serde.AvroKafkaSerializer;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.junit.jupiter.api.Assertions;

@QuarkusTest
public class SerdeMixTest
extends AbstractResourceTestBase {
    private SchemaRegistryClient buildClient() {
        return new CachedSchemaRegistryClient("http://localhost:8081/api/ccompat", 3);
    }

    @RegistryServiceTest
    public void testVersions(Supplier<RegistryService> supplier) throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord5\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject, schema);
        client.reset();
        TestUtils.retry(() -> {
            Schema schema2 = client.getById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        CompletionStage cs = supplier.get().updateArtifact(subject, ArtifactType.AVRO, (InputStream)new ByteArrayInputStream(IoUtil.toBytes((String)schema.toString())));
        ArtifactMetaData amd1 = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)cs);
        TestUtils.retry(() -> {
            ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(amd1.getGlobalId().longValue());
            return null;
        });
        cs = supplier.get().updateArtifact(subject, ArtifactType.AVRO, (InputStream)new ByteArrayInputStream(IoUtil.toBytes((String)schema.toString())));
        ArtifactMetaData amd2 = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)cs);
        TestUtils.retry(() -> {
            ((RegistryService)supplier.get()).getArtifactMetaDataByGlobalId(amd2.getGlobalId().longValue());
            return null;
        });
        List versions1 = client.getAllVersions(subject);
        Assertions.assertEquals((int)3, (int)versions1.size());
        Assertions.assertTrue((boolean)versions1.contains(1));
        Assertions.assertTrue((boolean)versions1.contains(2));
        Assertions.assertTrue((boolean)versions1.contains(3));
        List versions2 = supplier.get().listArtifactVersions(subject);
        Assertions.assertEquals((int)3, (int)versions2.size());
        Assertions.assertTrue((boolean)versions2.contains(1L));
        Assertions.assertTrue((boolean)versions2.contains(2L));
        Assertions.assertTrue((boolean)versions2.contains(3L));
        client.deleteSchemaVersion(subject, "1");
        TestUtils.retry(() -> {
            try {
                ((RegistryService)supplier.get()).getArtifactVersionMetaData(Integer.valueOf(1), subject);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        versions1 = client.getAllVersions(subject);
        Assertions.assertEquals((int)2, (int)versions1.size());
        Assertions.assertFalse((boolean)versions1.contains(1));
        Assertions.assertTrue((boolean)versions1.contains(2));
        Assertions.assertTrue((boolean)versions1.contains(3));
        versions2 = supplier.get().listArtifactVersions(subject);
        Assertions.assertEquals((int)2, (int)versions2.size());
        Assertions.assertFalse((boolean)versions2.contains(1L));
        Assertions.assertTrue((boolean)versions2.contains(2L));
        Assertions.assertTrue((boolean)versions2.contains(3L));
    }

    @RegistryServiceTest
    public void testSerdeMix(Supplier<RegistryService> supplier) throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord5\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        client.register(subject + "-value", schema);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("bar", (Object)"somebar");
        AvroKafkaDeserializer deserializer1 = new AvroKafkaDeserializer(supplier.get());
        deserializer1.asLegacyId();
        try (KafkaAvroSerializer serializer1 = new KafkaAvroSerializer(client);){
            byte[] bytes = serializer1.serialize(subject, (Object)record);
            TestUtils.waitForSchema((RegistryService)supplier.get(), (byte[])bytes, bb -> bb.getInt());
            GenericData.Record ir = (GenericData.Record)deserializer1.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
        AvroKafkaSerializer serializer2 = new AvroKafkaSerializer(supplier.get());
        serializer2.asLegacyId();
        try (KafkaAvroDeserializer deserializer2 = new KafkaAvroDeserializer(client);){
            byte[] bytes = serializer2.serialize(subject, (Object)record);
            GenericData.Record ir = (GenericData.Record)deserializer2.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }
}

