/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.cluster;

import io.apicurio.registry.client.RegistryClient;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.cluster.support.ClusterUtils;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SearchedArtifact;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.support.HealthResponse;
import io.apicurio.registry.support.HealthUtils;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.SmallRyeConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.apache.avro.Schema;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ClusterIT {
    @BeforeAll
    public static void startCluster() throws Exception {
        ClassLoader systemCL = new ClassLoader(null){};
        Config config = ConfigProviderResolver.instance().getConfig(systemCL);
        QuarkusConfigFactory.setConfig((SmallRyeConfig)((SmallRyeConfig)config));
        ClusterUtils.startCluster();
    }

    @AfterAll
    public static void stopCluster() {
        ClusterUtils.stopCluster();
    }

    private void testReadiness(int port) throws Exception {
        HealthUtils.assertHealthCheck(port, HealthUtils.Type.READY, HealthResponse.Status.UP);
    }

    @Test
    public void testReadiness() throws Exception {
        Properties properties = ClusterUtils.getClusterProperties();
        Assumptions.assumeTrue((properties != null ? 1 : 0) != 0);
        this.testReadiness(8080);
        this.testReadiness(8081);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmoke() throws Exception {
        Properties properties = ClusterUtils.getClusterProperties();
        Assumptions.assumeTrue((properties != null ? 1 : 0) != 0);
        RegistryService client1 = RegistryClient.create((String)"http://localhost:8080/api");
        RegistryService client2 = RegistryClient.create((String)"http://localhost:8081/api");
        client1.listArtifacts();
        client2.listArtifacts();
        String artifactId = UUID.randomUUID().toString();
        ByteArrayInputStream stream = new ByteArrayInputStream("{\"name\":\"redhat\"}".getBytes(StandardCharsets.UTF_8));
        CompletionStage cs = client1.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)stream);
        try {
            TestUtils.retry(() -> {
                ArtifactMetaData amd = client2.getArtifactMetaData(artifactId);
                Assertions.assertEquals((int)1, (Integer)amd.getVersion());
            });
            String name = UUID.randomUUID().toString();
            String desc = UUID.randomUUID().toString();
            EditableMetaData emd = new EditableMetaData();
            emd.setName(name);
            emd.setDescription(desc);
            client1.updateArtifactMetaData(artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData amd = client2.getArtifactMetaDataByGlobalId(((ArtifactMetaData)ConcurrentUtil.result((CompletionStage)cs)).getGlobalId().longValue());
                Assertions.assertEquals((Object)name, (Object)amd.getName());
                Assertions.assertEquals((Object)desc, (Object)amd.getDescription());
            });
            Rule rule = new Rule();
            rule.setType(RuleType.VALIDITY);
            rule.setConfig("myconfig");
            client1.createArtifactRule(artifactId, rule);
            TestUtils.retry(() -> {
                Rule config = client2.getArtifactRuleConfig(RuleType.VALIDITY, artifactId);
                Assertions.assertEquals((Object)rule.getConfig(), (Object)config.getConfig());
            });
            List v1 = client1.listArtifactVersions(artifactId);
            List v2 = client2.listArtifactVersions(artifactId);
            Assertions.assertEquals((Object)v1, (Object)v2);
            List rt1 = client1.listArtifactRules(artifactId);
            List rt2 = client2.listArtifactRules(artifactId);
            Assertions.assertEquals((Object)rt1, (Object)rt2);
            Rule globalRule = new Rule();
            globalRule.setType(RuleType.COMPATIBILITY);
            globalRule.setConfig("gc");
            client1.createGlobalRule(globalRule);
            try {
                TestUtils.retry(() -> {
                    List grts = client2.listGlobalRules();
                    Assertions.assertTrue((boolean)grts.contains(globalRule.getType()));
                });
            }
            finally {
                client1.deleteGlobalRule(RuleType.COMPATIBILITY);
            }
        }
        finally {
            client1.deleteArtifact(artifactId);
        }
        client1.close();
        client2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfluent() throws Exception {
        Properties properties = ClusterUtils.getClusterProperties();
        Assumptions.assumeTrue((properties != null ? 1 : 0) != 0);
        CachedSchemaRegistryClient client1 = new CachedSchemaRegistryClient("http://localhost:8080/api/ccompat", 3);
        CachedSchemaRegistryClient client2 = new CachedSchemaRegistryClient("http://localhost:8081/api/ccompat", 3);
        String subject = UUID.randomUUID().toString();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}");
        int id = client1.register(subject, schema);
        try {
            TestUtils.retry(() -> ClusterIT.lambda$testConfluent$4((SchemaRegistryClient)client2, subject));
            TestUtils.retry(() -> ClusterIT.lambda$testConfluent$5((SchemaRegistryClient)client2, id));
        }
        finally {
            client1.deleteSchemaVersion(subject, "1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearch() throws Exception {
        Properties properties = ClusterUtils.getClusterProperties();
        Assumptions.assumeTrue((properties != null ? 1 : 0) != 0);
        RegistryService client1 = RegistryClient.create((String)"http://localhost:8080/api");
        RegistryService client2 = RegistryClient.create((String)"http://localhost:8081/api");
        client1.listArtifacts();
        client2.listArtifacts();
        String artifactId = UUID.randomUUID().toString();
        ByteArrayInputStream stream = new ByteArrayInputStream("{\"name\":\"redhat\"}".getBytes(StandardCharsets.UTF_8));
        client1.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)stream);
        try {
            String name = UUID.randomUUID().toString();
            String desc = UUID.randomUUID().toString();
            EditableMetaData emd = new EditableMetaData();
            emd.setName(name);
            emd.setDescription(desc);
            client2.updateArtifactMetaData(artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactSearchResults results = client2.searchArtifacts(name, Integer.valueOf(0), Integer.valueOf(2), SearchOver.name, SortOrder.asc);
                Assertions.assertNotNull((Object)results);
                Assertions.assertEquals((int)1, (Integer)results.getCount(), (String)"Invalid results count -- name");
                Assertions.assertEquals((int)1, (int)results.getArtifacts().size(), (String)"Invalid artifacts size -- name");
                Assertions.assertEquals((Object)name, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getName());
                Assertions.assertEquals((Object)desc, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getDescription());
            });
            TestUtils.retry(() -> {
                ArtifactSearchResults results = client1.searchArtifacts(desc, Integer.valueOf(0), Integer.valueOf(2), SearchOver.description, SortOrder.desc);
                Assertions.assertNotNull((Object)results);
                Assertions.assertEquals((int)1, (Integer)results.getCount(), (String)"Invalid results count -- description");
                Assertions.assertEquals((int)1, (int)results.getArtifacts().size(), (String)"Invalid artifacts size -- description");
                Assertions.assertEquals((Object)name, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getName());
                Assertions.assertEquals((Object)desc, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getDescription());
            });
            TestUtils.retry(() -> {
                ArtifactSearchResults results = client2.searchArtifacts(desc, Integer.valueOf(0), Integer.valueOf(2), SearchOver.everything, SortOrder.desc);
                Assertions.assertNotNull((Object)results);
                Assertions.assertEquals((int)1, (Integer)results.getCount(), (String)"Invalid results count -- everything");
                Assertions.assertEquals((int)1, (int)results.getArtifacts().size(), (String)"Invalid artifacts size -- everything");
                Assertions.assertEquals((Object)name, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getName());
                Assertions.assertEquals((Object)desc, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getDescription());
            });
        }
        finally {
            client1.deleteArtifact(artifactId);
        }
        client1.close();
        client2.close();
    }

    private static /* synthetic */ void lambda$testConfluent$5(SchemaRegistryClient client2, int id) throws Exception {
        Schema s = client2.getById(id);
        Assertions.assertNotNull((Object)s);
    }

    private static /* synthetic */ void lambda$testConfluent$4(SchemaRegistryClient client2, String subject) throws Exception {
        Collection allSubjects = client2.getAllSubjects();
        Assertions.assertTrue((boolean)allSubjects.contains(subject));
    }
}

