/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.cluster.support;

import io.apicurio.registry.util.ClusterInitializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterUtils {
    private static final Logger log = LoggerFactory.getLogger(ClusterUtils.class);
    private static Process[] nodes;
    private static ClusterInitializer initializer;

    public static void startCluster() throws Exception {
        Properties properties = ClusterUtils.getClusterProperties();
        if (properties == null) {
            return;
        }
        Map<String, String> configMap = Collections.emptyMap();
        String ci = properties.getProperty("initializer");
        if (ci != null) {
            ClassLoader classLoader = ClusterUtils.class.getClassLoader();
            initializer = (ClusterInitializer)classLoader.loadClass(ci).newInstance();
            configMap = initializer.startCluster();
        }
        int N = Integer.parseInt(properties.getProperty("nodes", "2"));
        nodes = new Process[N];
        for (int i = 0; i < N; ++i) {
            ClusterUtils.nodes[i] = ClusterUtils.startNode(configMap, i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopCluster() {
        if (nodes != null) {
            try {
                for (Process node : nodes) {
                    node.destroyForcibly();
                }
            }
            finally {
                nodes = null;
                ClusterInitializer ci = initializer;
                initializer = null;
                if (ci != null) {
                    ci.stopCluster();
                }
            }
        }
    }

    public static Properties getClusterProperties() throws Exception {
        String buildDir = System.getProperty("project.build.directory");
        if (buildDir == null) {
            return null;
        }
        String finalName = System.getProperty("project.build.finalName");
        String runner = String.format("%s/%s-runner.jar", buildDir, finalName);
        File runnerFile = new File(runner);
        if (!runnerFile.exists()) {
            log.info("No Registry runner jar ... " + runner);
            return null;
        }
        File file = new File(buildDir, "test-classes/cluster-test.properties");
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(file);){
            properties.load(stream);
        }
        return properties;
    }

    private static Process startNode(Map<String, String> config, int node) throws Exception {
        String end;
        Properties properties = ClusterUtils.getClusterProperties();
        String dir = System.getProperty("project.build.directory");
        String name = System.getProperty("project.build.finalName");
        String props = properties.getProperty(String.format("node%s.props", node));
        for (Map.Entry<String, String> entry : config.entrySet()) {
            props = props.replace(String.format("${%s}", entry.getKey()), entry.getValue());
        }
        String cmd = String.format("java -jar %s %s/%s-runner.jar", props, dir, name);
        log.info("Node cmd > " + cmd);
        LinkedHashSet<String> ends = new LinkedHashSet<String>();
        int i = 1;
        while ((end = properties.getProperty("end." + i)) != null) {
            ends.add(end);
            ++i;
        }
        log.info("Matching ends: " + ends);
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream is = process.getInputStream();
        InputStream err = process.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        BufferedReader errReader = new BufferedReader(new InputStreamReader(err));
        ArrayList msgs = new ArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            try {
                while (process.isAlive()) {
                    String line = reader.readLine();
                    if (line != null) {
                        log.info("Registry > " + line);
                        msgs.add(line);
                        if (!ClusterUtils.found(line, ends)) continue;
                        log.info("Registry started ...");
                        latch.countDown();
                        return;
                    }
                    String errLine = errReader.readLine();
                    if (errLine == null) continue;
                    log.error("Registry err > " + errLine);
                    msgs.add("e: " + errLine);
                }
                int exitValue = process.exitValue();
                if (exitValue == 0) {
                    log.info("Registry process exited OK");
                } else {
                    log.error("Registry process exited with error: " + exitValue + ", msgs: " + msgs);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            latch.countDown();
        }, "Node-thread-" + node);
        t.start();
        latch.await();
        Thread logThread = new Thread(() -> {
            try {
                while (process.isAlive()) {
                    String line = reader.readLine();
                    if (line != null) {
                        log.info("Registry > " + line);
                        continue;
                    }
                    String errLine = errReader.readLine();
                    if (errLine == null) continue;
                    log.error("Registry err > " + errLine);
                }
                int exitValue = process.exitValue();
                if (exitValue == 0) {
                    log.info("Registry process exited OK");
                } else {
                    log.error("Registry process exited with error: " + exitValue + ", msgs: " + msgs);
                }
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        });
        logThread.start();
        return process;
    }

    private static boolean found(String line, Set<String> ends) {
        for (String end : ends) {
            if (!line.contains(end)) continue;
            return true;
        }
        return false;
    }
}

