/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.compatibility;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.rules.compatibility.CompatibilityRuleExecutor;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CompatibilityRuleApplicationTest
extends AbstractResourceTestBase {
    private static final String SCHEMA_SIMPLE = "{\"type\": \"string\"}";
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rules;
    @Inject
    CompatibilityRuleExecutor compatibility;

    @Test
    public void testGlobalCompatibilityRuleNoArtifact() {
        this.storage.createGlobalRule(RuleType.COMPATIBILITY, RuleConfigurationDto.builder().configuration("FULL").build());
        this.rules.applyRules("not-existent", ArtifactType.AVRO, ContentHandle.create((String)SCHEMA_SIMPLE), RuleApplicationType.CREATE);
    }

    @Test
    public void testAvroCompatibility() {
        String v1Schema = "{\"type\":\"record\",\"namespace\":\"com.example\",\"name\":\"FullName\",\"fields\":[{\"name\":\"first\",\"type\":\"string\"},{\"name\":\"last\",\"type\":\"string\"}]}";
        String v2Schema = SCHEMA_SIMPLE;
        Assertions.assertThrows(RuleViolationException.class, () -> {
            RuleContext context = new RuleContext("Test", ArtifactType.AVRO, "BACKWARD", ContentHandle.create((String)v1Schema), ContentHandle.create((String)v2Schema));
            this.compatibility.execute(context);
        });
    }
}

