/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=JsonDeserializer.class)
class SchemaRegistryRestAPIClient {
    private static Logger logger = LoggerFactory.getLogger(SchemaRegistryRestAPIClient.class);
    private final String apiKey;
    private final WebTarget schemasEndpoint;
    private final WebTarget schemaVersionsEndpoint;
    private final WebTarget schemaEndpoint;
    private final WebTarget schemaVersionEndpoint;
    private static TrustManager[] nullTrustManager = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    SchemaRegistryRestAPIClient(String url, String apikey, boolean skipSslValidation) throws Exception {
        this.apiKey = apikey;
        Client client = SchemaRegistryRestAPIClient.getJAXRSClient(skipSslValidation);
        this.schemasEndpoint = client.target(url).path("/schemas");
        this.schemaVersionsEndpoint = client.target(url).path("/schemas/{schemaid}/versions");
        this.schemaEndpoint = client.target(url).path("/schemas/{schemaid}");
        this.schemaVersionEndpoint = client.target(url).path("/schemas/{schemaid}/versions/{versionnum}");
        this.connectionTest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<?> post(String schemaId, Response response) throws Exception {
        int status = response.getStatus();
        try {
            if (status == 201) {
                Tuple<Object> tuple = new Tuple<Object>(status, response.readEntity(SchemaInfoResponse.class));
                return tuple;
            }
            if (status == 200) {
                Tuple<Object> tuple = new Tuple<Object>(status, response.readEntity(String.class));
                return tuple;
            }
            this.handleErrorResponse(response, schemaId, null);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    Tuple<?> create(String schemaId, String schema, boolean verify) throws Exception {
        Response response = this.schemasEndpoint.queryParam("verify", new Object[]{verify}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)new NewSchema(schemaId, schema), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return this.post(schemaId, response);
    }

    Tuple<?> update(String schemaId, String schema, boolean verify) throws Exception {
        Response response = this.schemaVersionsEndpoint.resolveTemplate("schemaid", (Object)schemaId).queryParam("verify", new Object[]{verify}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)new NewSchemaVersion(schema), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return this.post(schemaId, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaResponse get(String schemaId, String versionId) throws Exception {
        Response response = this.getResponse(this.schemaVersionEndpoint.resolveTemplateFromEncoded("schemaid", (Object)schemaId).resolveTemplate("versionnum", (Object)versionId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}));
        int status = response.getStatus();
        try {
            if (status == 200) {
                SchemaResponse schemaResponse = (SchemaResponse)response.readEntity(SchemaResponse.class);
                return schemaResponse;
            }
            this.handleErrorResponse(response, schemaId, versionId);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaInfoResponse get(String schemaId) throws Exception {
        Response response = this.getResponse(this.schemaEndpoint.resolveTemplateFromEncoded("schemaid", (Object)schemaId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}));
        int status = response.getStatus();
        try {
            if (status == 200) {
                SchemaInfoResponse schemaInfoResponse = (SchemaInfoResponse)response.readEntity(SchemaInfoResponse.class);
                return schemaInfoResponse;
            }
            this.handleErrorResponse(response, schemaId, null);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    public void handleErrorResponse(Response response, String schemaId, String versionId) throws Exception {
        int status = response.getStatus();
        if (status == 404) {
            ErrorResponse jsonObject = (ErrorResponse)response.readEntity(ErrorResponse.class);
            if (jsonObject.message != null && (jsonObject.message.equals("Schema not found") || jsonObject.message.equals("Schema version not found"))) {
                if (versionId == null) {
                    throw new Exception("Schema id: " + schemaId);
                }
                throw new Exception("Schema id: " + schemaId + ", version id: " + versionId);
            }
        } else {
            if (status == 401 || status == 403) {
                logger.error("Auth failure. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
            if (status == 500) {
                ErrorResponse obj = (ErrorResponse)response.readEntity(ErrorResponse.class);
                logger.error("Server error from Schema Registry : {}", (Object)obj.message);
                throw new Exception("HTTP response status: " + status + " -- " + obj.message);
            }
            if (status > 500) {
                logger.error("Unexpected server error from Schema Registry. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionTest(String url) throws Exception {
        block7: {
            Response response = this.getResponse(this.schemasEndpoint.request());
            int status = response.getStatus();
            try {
                if (status == 200) {
                    logger.debug("Connected to Schema Registry {}", (Object)url);
                    break block7;
                }
                if (status == 401 || status == 403) {
                    logger.error("Failed to connect to Schema Registry. Status code {}", (Object)status);
                    throw new Exception("HTTP response status: " + status);
                }
                if (status == 500) {
                    ErrorResponse obj = (ErrorResponse)response.readEntity(ErrorResponse.class);
                    logger.error("Server error from Schema Registry : {}", (Object)obj.message);
                    throw new Exception("HTTP response status: " + status + " -- " + obj.message);
                }
                if (status > 500) {
                    logger.error("Server error from Schema Registry. Status code {}", (Object)status);
                    throw new Exception("HTTP response status: " + status);
                }
                logger.error("Unexpected response. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
            finally {
                response.close();
            }
        }
    }

    private Response getResponse(Invocation.Builder builder) throws Exception {
        try {
            return builder.header("Authorization", (Object)("Bearer " + this.apiKey)).get();
        }
        catch (ProcessingException pe) {
            logger.error("Failed to make API request", (Throwable)pe);
            Throwable cause = pe.getCause();
            throw new Exception(cause != null ? cause : pe);
        }
    }

    private static Client getJAXRSClient(boolean skipSSLValidation) throws KeyManagementException, NoSuchAlgorithmException {
        Client newClient;
        ClientBuilder cb = ClientBuilder.newBuilder();
        cb.connectTimeout(10L, TimeUnit.SECONDS);
        if (skipSSLValidation) {
            SSLContext nullSSLContext = SSLContext.getInstance("TLSv1.2");
            nullSSLContext.init(null, nullTrustManager, null);
            cb.hostnameVerifier((HostnameVerifier)NullHostnameVerifier.INSTANCE).sslContext(nullSSLContext);
            newClient = cb.build();
        } else {
            newClient = cb.build();
        }
        newClient.register(JacksonJsonProvider.class);
        return newClient;
    }

    static class Tuple<T> {
        int status;
        T result;

        Tuple(int status, T result) {
            this.status = status;
            this.result = result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class StateResponse {
        @JsonProperty
        String state;
        @JsonProperty
        String comment;

        StateResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionResponse {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;

        VersionResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SchemaResponse {
        @JsonProperty
        String id;
        @JsonProperty
        VersionResponse version;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;
        @JsonProperty
        String definition;

        SchemaResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SchemaInfoResponse {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;
        @JsonProperty
        List<VersionResponse> versions = new ArrayList<VersionResponse>();
        @JsonProperty
        List<String> topics = new ArrayList<String>();

        SchemaInfoResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ErrorResponse {
        @JsonProperty
        String message;

        ErrorResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class NewSchema
    extends NewSchemaVersion {
        @JsonProperty
        String name;

        public NewSchema() {
        }

        public NewSchema(String name, String definition) {
            super(definition);
            this.name = name;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class NewSchemaVersion {
        @JsonProperty
        String definition;

        public NewSchemaVersion() {
        }

        public NewSchemaVersion(String definition) {
            this.definition = definition;
        }
    }

    private static class NullHostnameVerifier
    implements HostnameVerifier {
        public static final NullHostnameVerifier INSTANCE = new NullHostnameVerifier();

        private NullHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

