/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.maven.DownloadRegistryMojo;
import io.apicurio.registry.maven.RegistryMojoTestBase;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@QuarkusTest
public class DownloadRegistryMojoTest
extends RegistryMojoTestBase {
    DownloadRegistryMojo mojo;

    @BeforeEach
    public void createMojo() {
        this.mojo = new DownloadRegistryMojo();
        this.mojo.registryUrl = "http://localhost:8081/api";
    }

    @RegistryServiceTest
    public void testDownloadIds(Supplier<RegistryService> supplier) throws Exception {
        String artifactId = this.generateArtifactId();
        Schema schema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        CompletionStage cs = supplier.get().createArtifact(ArtifactType.AVRO, artifactId, null, (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        cs.toCompletableFuture().get();
        this.mojo.ids = Collections.singleton(artifactId);
        this.mojo.artifactExtension = ".avsc";
        this.mojo.outputDirectory = this.tempDirectory;
        this.mojo.execute();
        Assertions.assertTrue((boolean)new File(this.mojo.outputDirectory, artifactId + this.mojo.artifactExtension).exists());
    }
}

