/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.maven.RegisterRegistryMojo;
import io.apicurio.registry.maven.RegistryMojoTestBase;
import io.apicurio.registry.types.ArtifactType;
import io.quarkus.test.junit.QuarkusTest;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegisterRegistryMojoTest
extends RegistryMojoTestBase {
    RegisterRegistryMojo mojo;

    @BeforeEach
    public void createMojo() {
        this.mojo = new RegisterRegistryMojo();
        this.mojo.registryUrl = "http://localhost:8081/api";
    }

    @Test
    public void testRegister() throws IOException, MojoFailureException, MojoExecutionException {
        LinkedHashMap<String, Integer> expectedVersions = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, File> idToFile = new LinkedHashMap<String, File>();
        int version = 1;
        for (int i = 0; i < 10; ++i) {
            String keySubject = String.format("TestSubject%03d-key", i);
            String valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            this.writeContent(keySchemaFile, keySchema.toString(true).getBytes(StandardCharsets.UTF_8));
            this.writeContent(valueSchemaFile, valueSchema.toString(true).getBytes(StandardCharsets.UTF_8));
            idToFile.put(keySubject, keySchemaFile);
            expectedVersions.put(keySubject, version);
            idToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, version);
        }
        this.mojo.artifacts = idToFile;
        this.mojo.artifactType = ArtifactType.AVRO;
        this.mojo.execute();
        Assertions.assertEquals((Object)this.mojo.artifactVersions, expectedVersions);
    }
}

