/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.maven.RegistryMojoTestBase;
import io.apicurio.registry.maven.TestUpdateRegistryMojo;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@QuarkusTest
public class TestUpdateRegistryMojoTest
extends RegistryMojoTestBase {
    TestUpdateRegistryMojo mojo;

    @BeforeEach
    public void createMojo() {
        this.mojo = new TestUpdateRegistryMojo();
        this.mojo.registryUrl = "http://localhost:8081/api";
    }

    @RegistryServiceTest
    public void testCompatibility(Supplier<RegistryService> supplier) throws Exception {
        String artifactId = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"user\", \"fields\": [     {\"name\": \"name\", \"type\": \"string\"},     {\"name\": \"favorite_number\",  \"type\": \"int\"} ]}");
        CompletionStage cs = supplier.get().createArtifact(ArtifactType.AVRO, artifactId, null, (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        cs.toCompletableFuture().get();
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        supplier.get().createArtifactRule(artifactId, rule);
        Schema schema2 = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"user\", \"fields\": [     {\"name\": \"name\", \"type\": \"string\"},     {\"name\": \"favorite_number\",  \"type\": \"int\"},     {\"name\": \"favorite_color\", \"type\": \"string\", \"default\": \"green\"} ]}");
        File file = new File(this.tempDirectory, artifactId + ".avsc");
        this.writeContent(file, schema2.toString().getBytes(StandardCharsets.UTF_8));
        this.mojo.artifacts = Collections.singletonMap(artifactId, file);
        this.mojo.artifactType = ArtifactType.AVRO;
        this.mojo.execute();
        Assertions.assertTrue((boolean)((Boolean)this.mojo.results.get(artifactId)));
    }
}

