/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaDiffLibrary;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaSmokeTest
extends AbstractRegistryTestBase {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaSmokeTest.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testComparison() throws Exception {
        HashSet<String> failed = new HashSet<String>();
        JSONObject testData = (JSONObject)MAPPER.readValue(this.resourceToString("compatibility-test-data.json"), JSONObject.class);
        JSONArray testCasesData = testData.getJSONArray("tests");
        block10: for (Object testCaseData_ : testCasesData) {
            JSONObject testCaseData = (JSONObject)testCaseData_;
            String caseId = testCaseData.getString("id");
            if (!testCaseData.getBoolean("enabled")) {
                log.warn("Skipping {}", (Object)caseId);
                continue;
            }
            DiffContext backward = JsonSchemaDiffLibrary.findDifferences((String)testCaseData.get("original").toString(), (String)testCaseData.get("updated").toString());
            DiffContext forward = JsonSchemaDiffLibrary.findDifferences((String)testCaseData.get("updated").toString(), (String)testCaseData.get("original").toString());
            boolean backwardCompatible = backward.foundAllDifferencesAreCompatible();
            boolean forwardCompatible = forward.foundAllDifferencesAreCompatible();
            switch (testCaseData.getString("compatibility")) {
                case "backward": {
                    if (backwardCompatible && !forwardCompatible) {
                        log.debug("OK caseId: {}", (Object)caseId);
                        continue block10;
                    }
                    failed.add(caseId);
                    log.error("\nFailed caseId: {}\nBackward {}: {}\nForward {}: {}\n", new Object[]{caseId, backwardCompatible, backward.getDiff(), forwardCompatible, forward.getDiff()});
                    continue block10;
                }
                case "both": {
                    if (backwardCompatible && forwardCompatible) {
                        log.debug("OK caseId: {}", (Object)caseId);
                        continue block10;
                    }
                    failed.add(caseId);
                    log.error("\nFailed caseId: {}\nBackward {}: {}\nForward {}: {}\n", new Object[]{caseId, backwardCompatible, backward.getDiff(), forwardCompatible, forward.getDiff()});
                    continue block10;
                }
                case "none": {
                    if (!backwardCompatible && !forwardCompatible) {
                        log.debug("OK caseId: {}", (Object)caseId);
                        continue block10;
                    }
                    failed.add(caseId);
                    log.error("\nFailed caseId: {}\nBackward {}: {}\nForward {}: {}\n", new Object[]{caseId, backwardCompatible, backward.getDiff(), forwardCompatible, forward.getDiff()});
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unsupported compatibility: " + testCaseData.getString("compatibility"));
        }
        if (!failed.isEmpty()) {
            throw new RuntimeException(failed.size() + " test cases failed: " + failed.stream().reduce("", (a, s) -> a + "\n" + s));
        }
    }

    static {
        MAPPER.registerModule((Module)new JsonOrgModule());
    }
}

