/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.AsyncApiContentValidator;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncApiContentValidatorTest
extends AbstractRegistryTestBase {
    @Test
    public void testValidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("asyncapi-valid-syntax.json");
        AsyncApiContentValidator validator = new AsyncApiContentValidator();
        validator.validate(ValidityLevel.SYNTAX_ONLY, content);
    }

    @Test
    public void testValidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("asyncapi-valid-semantics.json");
        AsyncApiContentValidator validator = new AsyncApiContentValidator();
        validator.validate(ValidityLevel.FULL, content);
    }

    @Test
    public void testInvalidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("asyncapi-invalid-syntax.json");
        AsyncApiContentValidator validator = new AsyncApiContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.SYNTAX_ONLY, content));
    }

    @Test
    public void testInvalidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("asyncapi-invalid-semantics.json");
        AsyncApiContentValidator validator = new AsyncApiContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.FULL, content));
    }
}

