/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.KafkaConnectContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaConnectContentValidatorTest
extends AbstractRegistryTestBase {
    @Test
    public void testValidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("kconnect-valid.json");
        KafkaConnectContentValidator validator = new KafkaConnectContentValidator();
        validator.validate(ValidityLevel.SYNTAX_ONLY, content);
    }

    @Test
    public void testInvalidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("kconnect-invalid.json");
        KafkaConnectContentValidator validator = new KafkaConnectContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.SYNTAX_ONLY, content));
    }
}

