/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.google.protobuf.Descriptors;
import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.common.proto.Serde;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ProtobufFdContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.support.TestCmmn;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProtobufFdContentValidatorTest
extends AbstractRegistryTestBase {
    private Serde.Schema toSchemaProto(Descriptors.FileDescriptor file) {
        Serde.Schema.Builder b = Serde.Schema.newBuilder();
        b.setFile(file.toProto());
        for (Descriptors.FileDescriptor d : file.getDependencies()) {
            b.addImport(this.toSchemaProto(d));
        }
        return b.build();
    }

    @Test
    public void testValidProtobufFdContent() {
        TestCmmn.UUID uuid = TestCmmn.UUID.newBuilder().setLsb(77L).setMsb(23L).build();
        ContentHandle content = ContentHandle.create((byte[])this.toSchemaProto(uuid.getDescriptorForType().getFile()).toByteArray());
        ProtobufFdContentValidator validator = new ProtobufFdContentValidator();
        validator.validate(ValidityLevel.FULL, content);
    }

    @Test
    public void testInvalidProtobufFdContent() {
        ContentHandle content = ContentHandle.create((String)"qwerty");
        ProtobufFdContentValidator validator = new ProtobufFdContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.FULL, content));
    }
}

