/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.WsdlContentValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WsdlContentValidatorTest
extends AbstractRegistryTestBase {
    @Test
    public void testValidSyntax() throws Exception {
        ContentHandle contentA = this.resourceToContentHandle("wsdl-valid.wsdl");
        WsdlContentValidator validator = new WsdlContentValidator();
        validator.validate(ValidityLevel.SYNTAX_ONLY, contentA);
        ContentHandle contentB = this.resourceToContentHandle("wsdl-invalid-semantics.wsdl");
        validator.validate(ValidityLevel.SYNTAX_ONLY, contentB);
    }

    @Test
    public void testinValidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("wsdl-invalid-syntax.wsdl");
        WsdlContentValidator validator = new WsdlContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.SYNTAX_ONLY, content));
    }

    @Test
    public void testValidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("wsdl-valid.wsdl");
        WsdlContentValidator validator = new WsdlContentValidator();
        validator.validate(ValidityLevel.FULL, content);
    }

    @Test
    public void testinValidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("wsdl-invalid-semantics.wsdl");
        WsdlContentValidator validator = new WsdlContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.FULL, content));
    }
}

