/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XsdContentValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlContentValidatorTest
extends AbstractRegistryTestBase {
    @Test
    public void testValidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("xml-valid.xml");
        XsdContentValidator validator = new XsdContentValidator();
        validator.validate(ValidityLevel.SYNTAX_ONLY, content);
    }

    @Test
    public void testInvalidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("xml-invalid-syntax.xml");
        XsdContentValidator validator = new XsdContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.SYNTAX_ONLY, content));
    }
}

