/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XsdContentValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsdContentValidatorTest
extends AbstractRegistryTestBase {
    @Test
    public void testValidSyntax() throws Exception {
        ContentHandle contentA = this.resourceToContentHandle("xml-schema-valid.xsd");
        XsdContentValidator validator = new XsdContentValidator();
        validator.validate(ValidityLevel.SYNTAX_ONLY, contentA);
        ContentHandle contentB = this.resourceToContentHandle("xml-schema-invalid-semantics.xsd");
        validator.validate(ValidityLevel.SYNTAX_ONLY, contentB);
    }

    @Test
    public void testInvalidSyntax() throws Exception {
        ContentHandle content = this.resourceToContentHandle("xml-schema-invalid-syntax.xsd");
        XsdContentValidator validator = new XsdContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.SYNTAX_ONLY, content));
    }

    @Test
    public void testValidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("xml-schema-valid.xsd");
        XsdContentValidator validator = new XsdContentValidator();
        validator.validate(ValidityLevel.FULL, content);
    }

    @Test
    public void testInvalidSemantics() throws Exception {
        ContentHandle content = this.resourceToContentHandle("xml-schema-invalid-semantics.xsd");
        XsdContentValidator validator = new XsdContentValidator();
        Assertions.assertThrows(InvalidContentException.class, () -> validator.validate(ValidityLevel.FULL, content));
    }
}

