/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryStorageSmokeTest
extends AbstractResourceTestBase {
    static final String ARTIFACT_ID_1 = "artifactId1";
    static final String ARTIFACT_ID_2 = "artifactId2";
    static final String ARTIFACT_ID_3 = "artifactId3";
    @Inject
    @Current
    private RegistryStorage storage;

    protected RegistryStorage getStorage() {
        return this.storage;
    }

    private void delete(String artifactId, boolean rule) {
        try {
            if (rule) {
                this.getStorage().deleteArtifactRules(artifactId);
            } else {
                this.getStorage().deleteArtifact(artifactId);
            }
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            // empty catch block
        }
    }

    @Override
    @BeforeEach
    public void beforeEach() {
        super.beforeEach();
        this.getStorage().deleteGlobalRules();
        this.delete(ARTIFACT_ID_1, false);
        this.delete(ARTIFACT_ID_2, false);
        this.delete(ARTIFACT_ID_3, false);
        this.delete(ARTIFACT_ID_1, true);
        this.delete(ARTIFACT_ID_2, true);
        this.delete(ARTIFACT_ID_3, true);
    }

    @Test
    public void testArtifactsAndMeta() throws Exception {
        int size = this.getStorage().getArtifactIds().size();
        ArtifactMetaDataDto meta1 = (ArtifactMetaDataDto)ConcurrentUtil.result((CompletionStage)this.getStorage().createArtifact(ARTIFACT_ID_1, ArtifactType.JSON, ContentHandle.create((String)"content1")));
        ArtifactMetaDataDto meta2 = (ArtifactMetaDataDto)ConcurrentUtil.result((CompletionStage)this.getStorage().updateArtifact(ARTIFACT_ID_1, ArtifactType.JSON, ContentHandle.create((String)"content2")));
        ConcurrentUtil.result((CompletionStage)this.getStorage().createArtifact(ARTIFACT_ID_2, ArtifactType.AVRO, ContentHandle.create((String)"content3")));
        Assertions.assertEquals((int)(size + 2), (int)this.getStorage().getArtifactIds().size());
        Assertions.assertTrue((boolean)this.getStorage().getArtifactIds().contains(ARTIFACT_ID_1));
        StoredArtifact a1 = this.getStorage().getArtifact(ARTIFACT_ID_1);
        Assertions.assertNotNull((Object)a1);
        Assertions.assertNotNull((Object)a1.getId());
        Assertions.assertNotNull((Object)a1.getVersion());
        Assertions.assertNotNull((Object)a1.getContent());
        ArtifactMetaDataDto metaLatest = this.getStorage().getArtifactMetaData(ARTIFACT_ID_1);
        Assertions.assertEquals((Object)meta2, (Object)metaLatest);
        SortedSet versions = this.getStorage().getArtifactVersions(ARTIFACT_ID_1);
        Assertions.assertEquals((int)2, (int)versions.size());
        Assertions.assertTrue((boolean)versions.contains(a1.getVersion()));
        Assertions.assertEquals((Object)a1, (Object)this.getStorage().getArtifact(ARTIFACT_ID_1));
        this.getStorage().updateArtifactVersionMetaData(ARTIFACT_ID_1, (long)meta1.getVersion(), EditableArtifactMetaDataDto.builder().name("foo").build());
        TestUtils.retry(() -> {
            ArtifactVersionMetaDataDto vmeta1 = this.getStorage().getArtifactVersionMetaData(ARTIFACT_ID_1, (long)meta1.getVersion());
            ArtifactVersionMetaDataDto vmeta2 = this.getStorage().getArtifactVersionMetaData(ARTIFACT_ID_1, (long)meta2.getVersion());
            Assertions.assertNotEquals((Object)vmeta1, (Object)vmeta2);
            Assertions.assertEquals((Object)"foo", (Object)vmeta1.getName());
            Assertions.assertNull((Object)vmeta2.getName());
            return null;
        });
        SortedSet deleted = this.getStorage().deleteArtifact(ARTIFACT_ID_1);
        Assertions.assertEquals((int)2, (int)deleted.size());
        Assertions.assertTrue((boolean)deleted.contains(a1.getVersion()));
        TestUtils.retry(() -> {
            try {
                this.getStorage().getArtifactMetaData(ARTIFACT_ID_1);
                Assertions.fail();
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                // empty catch block
            }
            SortedSet set = this.getStorage().deleteArtifact(ARTIFACT_ID_2);
            Assertions.assertEquals((int)1, (int)set.size());
            return set;
        });
    }

    @Test
    public void testRules() throws Exception {
        int tries;
        ConcurrentUtil.result((CompletionStage)this.getStorage().createArtifact(ARTIFACT_ID_3, ArtifactType.JSON, ContentHandle.create((String)"content1")));
        Assertions.assertEquals((int)0, (int)this.getStorage().getArtifactRules(ARTIFACT_ID_3).size());
        Assertions.assertEquals((int)0, (int)this.getStorage().getGlobalRules().size());
        this.getStorage().createArtifactRule(ARTIFACT_ID_3, RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("config").build());
        this.getStorage().createGlobalRule(RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("config").build());
        for (tries = 5; tries > 0; --tries) {
            try {
                Assertions.assertEquals((int)1, (int)this.getStorage().getArtifactRules(ARTIFACT_ID_3).size());
                Assertions.assertTrue((boolean)this.getStorage().getArtifactRules(ARTIFACT_ID_3).contains(RuleType.VALIDITY));
                Assertions.assertEquals((Object)"config", (Object)this.getStorage().getArtifactRule(ARTIFACT_ID_3, RuleType.VALIDITY).getConfiguration());
                Assertions.assertEquals((int)1, (int)this.getStorage().getGlobalRules().size());
                Assertions.assertTrue((boolean)this.getStorage().getGlobalRules().contains(RuleType.VALIDITY));
                break;
            }
            catch (Throwable t) {
                Thread.sleep(100L);
                continue;
            }
        }
        Assertions.assertTrue((tries > 0 ? 1 : 0) != 0, (String)"Failed to create rules!");
        this.getStorage().deleteArtifact(ARTIFACT_ID_3);
    }
}

