/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.support.HealthResponse;
import java.io.InputStream;
import java.net.URL;
import org.junit.jupiter.api.Assertions;

public class HealthUtils {
    public static void assertHealthCheck(int port, Type type, HealthResponse.Status status) throws Exception {
        URL url = new URL(String.format("http://localhost:%s/health/%s", port, type.name().toLowerCase()));
        try (InputStream stream = url.openStream();){
            HealthResponse hr = (HealthResponse)new ObjectMapper().readValue(stream, HealthResponse.class);
            Assertions.assertEquals((Object)((Object)status), (Object)((Object)hr.status));
        }
    }

    public static void assertIsReady() throws Exception {
        HealthUtils.assertHealthCheck(8081, Type.READY, HealthResponse.Status.UP);
    }

    public static void assertIsLive() throws Exception {
        HealthUtils.assertHealthCheck(8081, Type.LIVE, HealthResponse.Status.UP);
    }

    public static enum Type {
        READY,
        LIVE;

    }
}

