/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.util.ArtifactTypeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArtifactTypeUtilTest
extends AbstractRegistryTestBase {
    ArtifactTypeUtilTest() {
    }

    @Test
    void testDiscoverType_JSON() {
        ContentHandle content = this.resourceToContentHandle("json-schema.json");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.JSON, (Object)type);
    }

    @Test
    void testDiscoverType_Avro() {
        ContentHandle content = this.resourceToContentHandle("avro.json");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.AVRO, (Object)type);
    }

    @Test
    void testDiscoverType_Proto() {
        ContentHandle content = this.resourceToContentHandle("protobuf.proto");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.PROTOBUF, (Object)type);
        content = this.resourceToContentHandle("protobuf.proto");
        type = ArtifactTypeUtil.discoverType((ContentHandle)content, (String)"application/x-protobuf");
        Assertions.assertEquals((Object)ArtifactType.PROTOBUF, (Object)type);
    }

    @Test
    void testDiscoverType_OpenApi() {
        ContentHandle content = this.resourceToContentHandle("openapi.json");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.OPENAPI, (Object)type);
        content = this.resourceToContentHandle("swagger.json");
        type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.OPENAPI, (Object)type);
        content = this.resourceToContentHandle("swagger.json");
        type = ArtifactTypeUtil.discoverType((ContentHandle)content, (String)"application/json");
        Assertions.assertEquals((Object)ArtifactType.OPENAPI, (Object)type);
    }

    @Test
    void testDiscoverType_AsyncApi() {
        ContentHandle content = this.resourceToContentHandle("asyncapi.json");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.ASYNCAPI, (Object)type);
    }

    @Test
    void testDiscoverType_GraphQL() {
        ContentHandle content = this.resourceToContentHandle("example.graphql");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.GRAPHQL, (Object)type);
    }

    @Test
    void testDiscoverType_DefaultNotFound() {
        Assertions.assertThrows(InvalidArtifactTypeException.class, () -> {
            ContentHandle content = this.resourceToContentHandle("example.txt");
            ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        });
    }

    @Test
    void testDiscoverType_Xml() {
        ContentHandle content = this.resourceToContentHandle("xml.xml");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.XML, (Object)type);
    }

    @Test
    void testDiscoverType_Xsd() {
        ContentHandle content = this.resourceToContentHandle("xml-schema.xsd");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.XSD, (Object)type);
    }

    @Test
    void testDiscoverType_Wsdl() {
        ContentHandle content = this.resourceToContentHandle("wsdl.wsdl");
        ArtifactType type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.WSDL, (Object)type);
        content = this.resourceToContentHandle("wsdl-2.0.wsdl");
        type = ArtifactTypeUtil.discoverType((ContentHandle)content, null);
        Assertions.assertEquals((Object)ArtifactType.WSDL, (Object)type);
    }
}

