/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.util.ContentTypeUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ContentTypeUtilTest {
    private static final String YAML_CONTENT = "openapi: 3.0.2\r\ninfo:\r\n    title: Empty API\r\n    version: 1.0.0\r\npaths:\r\n    /mice:\r\n        get:\r\n            responses:\r\n                '200':\r\n                    description: ...\r\ncomponents:\r\n    schemas:\r\n        Mouse:\r\n            description: ''\r\n            type: object\r\n";
    private static final String JSON_CONTENT = "{\r\n  \"openapi\" : \"3.0.2\",\r\n  \"info\" : {\r\n    \"title\" : \"Empty API\",\r\n    \"version\" : \"1.0.0\"\r\n  },\r\n  \"paths\" : {\r\n    \"/mice\" : {\r\n      \"get\" : {\r\n        \"responses\" : {\r\n          \"200\" : {\r\n            \"description\" : \"...\"\r\n          }\r\n        }\r\n      }\r\n    }\r\n  },\r\n  \"components\" : {\r\n    \"schemas\" : {\r\n      \"Mouse\" : {\r\n        \"description\" : \"\",\r\n        \"type\" : \"object\"\r\n      }\r\n    }\r\n  }\r\n}";

    ContentTypeUtilTest() {
    }

    @Test
    void testYamlToJson() throws Exception {
        ContentHandle yaml = ContentHandle.create((String)YAML_CONTENT);
        ContentHandle json = ContentTypeUtil.yamlToJson((ContentHandle)yaml);
        Assertions.assertEquals((Object)ContentTypeUtilTest.normalize(JSON_CONTENT), (Object)ContentTypeUtilTest.normalize(json.content()));
    }

    private static final String normalize(String value) throws Exception {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(value));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append("\n");
            line = reader.readLine();
        }
        return builder.toString();
    }
}

