/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.Optional;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class CompatibilityLevelDto {
    @JsonProperty(value="compatibility")
    private Level compatibilityLevel;

    public static CompatibilityLevelDto create(Optional<CompatibilityLevel> source) {
        return new CompatibilityLevelDto(Level.create(source));
    }

    public CompatibilityLevelDto() {
    }

    public CompatibilityLevelDto(Level compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public Level getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompatibilityLevelDto)) {
            return false;
        }
        CompatibilityLevelDto other = (CompatibilityLevelDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Level this$compatibilityLevel = this.getCompatibilityLevel();
        Level other$compatibilityLevel = other.getCompatibilityLevel();
        return !(this$compatibilityLevel == null ? other$compatibilityLevel != null : !((Object)((Object)this$compatibilityLevel)).equals((Object)other$compatibilityLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompatibilityLevelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Level $compatibilityLevel = this.getCompatibilityLevel();
        result = result * 59 + ($compatibilityLevel == null ? 43 : ((Object)((Object)$compatibilityLevel)).hashCode());
        return result;
    }

    public String toString() {
        return "CompatibilityLevelDto(compatibilityLevel=" + (Object)((Object)this.getCompatibilityLevel()) + ")";
    }

    public static enum Level {
        BACKWARD("BACKWARD"),
        BACKWARD_TRANSITIVE("BACKWARD_TRANSITIVE"),
        FORWARD("FORWARD"),
        FORWARD_TRANSITIVE("FORWARD_TRANSITIVE"),
        FULL("FULL"),
        FULL_TRANSITIVE("FULL_TRANSITIVE"),
        NONE("NONE");

        @JsonValue
        private final String stringValue;

        public static Level create(Optional<CompatibilityLevel> source) {
            return source.map(c -> {
                switch (c) {
                    case BACKWARD: {
                        return BACKWARD;
                    }
                    case BACKWARD_TRANSITIVE: {
                        return BACKWARD_TRANSITIVE;
                    }
                    case FORWARD: {
                        return FORWARD;
                    }
                    case FORWARD_TRANSITIVE: {
                        return FORWARD_TRANSITIVE;
                    }
                    case FULL: {
                        return FULL;
                    }
                    case FULL_TRANSITIVE: {
                        return FULL_TRANSITIVE;
                    }
                }
                return null;
            }).orElse(NONE);
        }

        private Level(String level) {
            this.stringValue = level;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

