/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.ccompat.dto.CompatibilityLevelDto;
import io.apicurio.registry.ccompat.rest.ConfigResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.types.RuleType;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.interceptor.Interceptors;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class ConfigResourceImpl
extends AbstractResource
implements ConfigResource {
    private CompatibilityLevelDto getCompatibilityLevel(Supplier<String> supplyLevel) {
        try {
            return CompatibilityLevelDto.create(Optional.of(CompatibilityLevel.valueOf(supplyLevel.get())));
        }
        catch (RuleNotFoundException ex) {
            return CompatibilityLevelDto.create(Optional.empty());
        }
    }

    private void updateCompatibilityLevel(CompatibilityLevelDto.Level level, Consumer<RuleConfigurationDto> updater, Runnable deleter) {
        if (level == CompatibilityLevelDto.Level.NONE) {
            deleter.run();
        } else {
            String levelString = level.getStringValue();
            try {
                CompatibilityLevel.valueOf(levelString);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Illegal compatibility level: " + levelString);
            }
            updater.accept(RuleConfigurationDto.builder().configuration(levelString).build());
        }
    }

    @Override
    public CompatibilityLevelDto getGlobalCompatibilityLevel() {
        return this.getCompatibilityLevel(() -> this.facade.getGlobalRule(RuleType.COMPATIBILITY).getConfiguration());
    }

    @Override
    public CompatibilityLevelDto updateGlobalCompatibilityLevel(CompatibilityLevelDto request) {
        this.updateCompatibilityLevel(request.getCompatibilityLevel(), dto -> this.facade.createOrUpdateGlobalRule(RuleType.COMPATIBILITY, (RuleConfigurationDto)dto), () -> this.facade.deleteGlobalRule(RuleType.COMPATIBILITY));
        return request;
    }

    @Override
    public CompatibilityLevelDto updateSubjectCompatibilityLevel(String subject, CompatibilityLevelDto request) {
        this.updateCompatibilityLevel(request.getCompatibilityLevel(), dto -> this.facade.createOrUpdateArtifactRule(subject, RuleType.COMPATIBILITY, (RuleConfigurationDto)dto), () -> this.facade.deleteArtifactRule(subject, RuleType.COMPATIBILITY));
        return request;
    }

    @Override
    public CompatibilityLevelDto getSubjectCompatibilityLevel(String subject) {
        return this.getCompatibilityLevel(() -> this.facade.getArtifactRule(subject, RuleType.COMPATIBILITY).getConfiguration());
    }
}

