/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.rest.beans.EditableMetaData;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroContentExtractor
implements ContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(AvroContentExtractor.class);
    public static final ContentExtractor INSTANCE = new AvroContentExtractor();
    private ObjectMapper mapper = new ObjectMapper();

    private AvroContentExtractor() {
    }

    @Override
    public EditableMetaData extract(ContentHandle content) {
        try {
            JsonNode avroSchema = this.mapper.readTree(content.bytes());
            JsonNode name = avroSchema.get("name");
            EditableMetaData metaData = null;
            if (name != null && !name.isNull()) {
                metaData = new EditableMetaData();
                metaData.setName(name.asText());
            }
            return metaData;
        }
        catch (IOException e) {
            log.warn("Error extracting metadata from JSON: {}", (Object)e.getMessage());
            return null;
        }
    }
}

