/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rest.RegistryApplication;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Logged
public class LoggingInterceptor {
    private static final Map<Class<?>, Logger> loggers = new HashMap();

    @AroundInvoke
    public Object logMethodEntry(InvocationContext context) throws Exception {
        Logger logger = null;
        try {
            Class targetClass = RegistryApplication.class;
            Object target = context.getTarget();
            if (target != null) {
                targetClass = target.getClass();
            }
            logger = this.getLogger(targetClass);
        }
        catch (Throwable targetClass) {
            // empty catch block
        }
        logger.debug("ENTERING method [{}] with {} parameters", (Object)context.getMethod().getName(), (Object)context.getParameters().length);
        Object rval = context.proceed();
        logger.debug("LEAVING method [{}]", (Object)context.getMethod().getName());
        return rval;
    }

    private Logger getLogger(Class<?> targetClass) {
        return loggers.computeIfAbsent(targetClass, k -> LoggerFactory.getLogger((Class)targetClass));
    }
}

