/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.PersistenceExceptionLivenessCheck;
import io.apicurio.registry.rest.RegistryExceptionMapper;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@PersistenceExceptionLivenessApply
public class PersistenceExceptionLivenessInterceptor {
    @Inject
    PersistenceExceptionLivenessCheck check;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        try {
            return context.proceed();
        }
        catch (Exception ex) {
            Set<Class<? extends Exception>> ignored = RegistryExceptionMapper.getIgnored();
            if (!ignored.contains(ex.getClass())) {
                this.check.suspectWithException(ex);
            }
            throw ex;
        }
    }
}

