/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.AbstractErrorCounterHealthCheck;
import io.apicurio.registry.metrics.LivenessCheck;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Liveness
@Default
public class ResponseErrorLivenessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck,
LivenessCheck {
    private static final Logger log = LoggerFactory.getLogger(ResponseErrorLivenessCheck.class);
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.errorThreshold", defaultValue="1")
    Integer configErrorThreshold;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.counterResetWindowDurationSec", defaultValue="60")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.statusResetWindowDurationSec", defaultValue="300")
    Integer configStatusResetWindowDurationSec;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("ResponseErrorLivenessCheck").withData("errorCount", this.errorCounter).state(this.up).build();
    }

    @Override
    public void suspect(String reason) {
        log.warn("Liveness problem suspected in ResponseErrorLivenessCheck: {}", (Object)reason);
        super.suspectSuper();
        log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
    }

    @Override
    public void suspectWithException(Throwable reason) {
        log.warn("Liveness problem suspected in ResponseErrorLivenessCheck because of an exception: ", reason);
        super.suspectSuper();
        log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
    }
}

