/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.IdsResource;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.util.DtoUtil;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class IdsResourceImpl
implements IdsResource,
Headers {
    @Inject
    @Current
    RegistryStorage storage;
    @Context
    HttpServletRequest request;

    public Response getArtifactByGlobalId(long globalId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(globalId);
        StoredArtifact artifact = this.storage.getArtifactVersion(globalId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, metaData.getId(), metaData.getVersion(), builder);
        return builder.build();
    }

    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(globalId);
        return DtoUtil.dtoToMetaData(dto.getId(), dto.getType(), dto);
    }
}

