/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaDiffLibrary;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public class JsonCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public boolean isCompatibleWith(CompatibilityLevel compatibilityLevel, List<String> existingSchemas, String proposedSchema) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingSchemas, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedSchema, "proposedSchema MUST NOT be null");
        if (existingSchemas.isEmpty()) {
            return true;
        }
        switch (compatibilityLevel) {
            case BACKWARD: {
                return JsonSchemaDiffLibrary.isCompatible(existingSchemas.get(existingSchemas.size() - 1), proposedSchema);
            }
            case BACKWARD_TRANSITIVE: {
                return this.transitively(existingSchemas, proposedSchema, JsonSchemaDiffLibrary::isCompatible);
            }
            case FORWARD: {
                return JsonSchemaDiffLibrary.isCompatible(proposedSchema, existingSchemas.get(existingSchemas.size() - 1));
            }
            case FORWARD_TRANSITIVE: {
                return this.transitively(existingSchemas, proposedSchema, (e, p) -> JsonSchemaDiffLibrary.isCompatible(p, e));
            }
            case FULL: {
                return JsonSchemaDiffLibrary.isCompatible(existingSchemas.get(existingSchemas.size() - 1), proposedSchema) && JsonSchemaDiffLibrary.isCompatible(proposedSchema, existingSchemas.get(existingSchemas.size() - 1));
            }
            case FULL_TRANSITIVE: {
                return this.transitively(existingSchemas, proposedSchema, JsonSchemaDiffLibrary::isCompatible) && this.transitively(existingSchemas, proposedSchema, (e, p) -> JsonSchemaDiffLibrary.isCompatible(p, e));
            }
        }
        return true;
    }

    private boolean transitively(List<String> existingSchemas, String proposedSchema, BiPredicate<String, String> checkProposedExisting) {
        String proposed = proposedSchema;
        for (int i = existingSchemas.size() - 1; i >= 0; --i) {
            String existing = existingSchemas.get(i);
            boolean result = checkProposedExisting.test(existing, proposed);
            proposed = existing;
            if (result) continue;
            return false;
        }
        return true;
    }
}

