/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.ProtobufCompatibilityCheckerImpl;
import io.apicurio.registry.rules.compatibility.ProtobufFile;
import java.util.List;
import java.util.Objects;

public class ProtobufCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public boolean isCompatibleWith(CompatibilityLevel compatibilityLevel, List<String> existingSchemas, String proposedSchema) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingSchemas, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedSchema, "proposedSchema MUST NOT be null");
        if (existingSchemas.isEmpty()) {
            return true;
        }
        switch (compatibilityLevel) {
            case BACKWARD: {
                ProtobufFile fileBefore = new ProtobufFile(existingSchemas.get(existingSchemas.size() - 1));
                ProtobufFile fileAfter = new ProtobufFile(proposedSchema);
                ProtobufCompatibilityCheckerImpl checker = new ProtobufCompatibilityCheckerImpl(fileBefore, fileAfter);
                return checker.validate();
            }
            case BACKWARD_TRANSITIVE: {
                ProtobufFile fileAfter = new ProtobufFile(proposedSchema);
                for (String existing : existingSchemas) {
                    ProtobufFile fileBefore = new ProtobufFile(existing);
                    ProtobufCompatibilityCheckerImpl checker = new ProtobufCompatibilityCheckerImpl(fileBefore, fileAfter);
                    if (checker.validate()) continue;
                    return false;
                }
                return true;
            }
            case FORWARD: 
            case FORWARD_TRANSITIVE: 
            case FULL: 
            case FULL_TRANSITIVE: {
                throw new IllegalStateException("Compatibility level " + (Object)((Object)compatibilityLevel) + " not supported for Protobuf schemas");
            }
        }
        return true;
    }
}

