/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.wrapper;

import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ArraySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.BooleanSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.CombinedSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConditionalSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConstSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EmptySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EnumSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.FalseSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NotSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NullSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NumberSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ObjectSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ReferenceSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.StringSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.TrueSchemaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;

public class WrapUtil {
    public static SchemaWrapper wrap(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema instanceof ObjectSchema) {
            return new ObjectSchemaWrapper((ObjectSchema)schema);
        }
        if (schema instanceof ArraySchema) {
            return new ArraySchemaWrapper((ArraySchema)schema);
        }
        if (schema instanceof StringSchema) {
            return new StringSchemaWrapper((StringSchema)schema);
        }
        if (schema instanceof EmptySchema && !(schema instanceof TrueSchema)) {
            return new EmptySchemaWrapper((EmptySchema)schema);
        }
        if (schema instanceof TrueSchema) {
            return new TrueSchemaWrapper((TrueSchema)schema);
        }
        if (schema instanceof FalseSchema) {
            return new FalseSchemaWrapper((FalseSchema)schema);
        }
        if (schema instanceof BooleanSchema) {
            return new BooleanSchemaWrapper((BooleanSchema)schema);
        }
        if (schema instanceof ConstSchema) {
            return new ConstSchemaWrapper((ConstSchema)schema);
        }
        if (schema instanceof EnumSchema) {
            return new EnumSchemaWrapper((EnumSchema)schema);
        }
        if (schema instanceof NullSchema) {
            return new NullSchemaWrapper((NullSchema)schema);
        }
        if (schema instanceof NotSchema) {
            return new NotSchemaWrapper((NotSchema)schema);
        }
        if (schema instanceof ReferenceSchema) {
            return new ReferenceSchemaWrapper((ReferenceSchema)schema);
        }
        if (schema instanceof CombinedSchema) {
            return new CombinedSchemaWrapper((CombinedSchema)schema);
        }
        if (schema instanceof ConditionalSchema) {
            return new ConditionalSchemaWrapper((ConditionalSchema)schema);
        }
        if (schema instanceof NumberSchema) {
            return new NumberSchemaWrapper((NumberSchema)schema);
        }
        throw new IllegalStateException("No wrapper for an underlying schema type '" + schema.getClass() + "': " + schema);
    }

    public static List<SchemaWrapper> wrap(List<Schema> itemSchemas) {
        if (itemSchemas == null) {
            return null;
        }
        return itemSchemas.stream().map(WrapUtil::wrap).collect(Collectors.toList());
    }

    public static <K> Map<K, SchemaWrapper> wrap(Map<K, Schema> map) {
        Objects.requireNonNull(map);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WrapUtil.wrap((Schema)e.getValue())));
    }

    public static Collection<SchemaWrapper> wrap(Collection<Schema> subschemas) {
        return WrapUtil.wrap(new ArrayList<Schema>(subschemas));
    }

    public static Optional<SchemaWrapper> wrap(Optional<Schema> schema) {
        return schema.map(WrapUtil::wrap);
    }
}

