/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XmlContentValidator;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import io.apicurio.registry.util.WSDLReaderAccessor;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import org.w3c.dom.Document;

@ApplicationScoped
public class WsdlContentValidator
extends XmlContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle artifactContent) throws InvalidContentException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try (InputStream stream = artifactContent.stream();){
                Document wsdlDoc = DocumentBuilderAccessor.getDocumentBuilder().parse(stream);
                if (level == ValidityLevel.FULL) {
                    WSDLReaderAccessor.getWSDLReader().readWSDL(null, wsdlDoc);
                }
            }
            catch (Exception e) {
                throw new InvalidContentException("Syntax violation for WSDL Schema artifact.", e);
            }
        }
    }
}

