/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.impl.InMemoryRegistryStorage;
import io.apicurio.registry.types.Current;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RegistryStorageProducer {
    private static Logger log = LoggerFactory.getLogger(RegistryStorageProducer.class);
    @Inject
    Instance<RegistryStorage> storages;

    @Produces
    @ApplicationScoped
    @Current
    public RegistryStorage realImpl() {
        List list = this.storages.stream().collect(Collectors.toList());
        RegistryStorage impl = null;
        if (list.size() == 1) {
            impl = (RegistryStorage)list.get(0);
        } else {
            for (RegistryStorage rs : list) {
                if (rs instanceof InMemoryRegistryStorage) continue;
                impl = rs;
                break;
            }
        }
        if (impl != null) {
            log.info(String.format("Using RegistryStore: %s", impl.getClass().getName()));
            return impl;
        }
        throw new IllegalStateException("Should not be here ... ?!");
    }
}

