/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.ui.beans.ConfigJs;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigJsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1624928159818173418L;
    @Inject
    @ConfigProperty(name="registry.ui.features.readOnly")
    Boolean featureReadOnly;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ct = "application/javascript; charset=" + StandardCharsets.UTF_8;
        response.setContentType(ct);
        JsonFactory f = new JsonFactory();
        try (JsonGenerator g = f.createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
            response.getOutputStream().write("var ApicurioRegistryConfig = ".getBytes("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            g.setCodec((ObjectCodec)mapper);
            g.useDefaultPrettyPrinter();
            ConfigJs config = new ConfigJs();
            config.mode = "prod";
            config.artifacts.url = this.generateApiUrl(request);
            config.ui.url = this.generateUiUrl(request);
            config.ui.contextPath = "/ui";
            config.features.readOnly = this.isFeatureReadOnly();
            g.writeObject((Object)config);
            g.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String generateApiUrl(HttpServletRequest request) {
        try {
            String url = request.getRequestURL().toString();
            url = new URI(url).resolve("/api").toString();
            return url;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateUiUrl(HttpServletRequest request) {
        try {
            String url = request.getRequestURL().toString();
            url = new URI(url).resolve("/ui").toString();
            return url;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFeatureReadOnly() {
        return this.featureReadOnly == null ? false : this.featureReadOnly;
    }
}

