/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@ApplicationScoped
public class SpecUrlFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CharResponseWrapper wrappedResponse = new CharResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        byte[] bytes = wrappedResponse.getByteArray();
        if (bytes != null && response.getContentType() != null && response.getContentType().contains("text/html")) {
            String specUrl = this.generateSpecUrl((HttpServletRequest)request);
            String out = new String(bytes, StandardCharsets.UTF_8);
            out = out.replace("SPEC_URL", specUrl);
            byte[] newBytes = out.getBytes(StandardCharsets.UTF_8);
            response.setContentLength(newBytes.length);
            response.getOutputStream().write(newBytes);
        } else if (bytes != null && bytes.length > 0) {
            response.getOutputStream().write(bytes);
        }
    }

    public void destroy() {
    }

    private String generateSpecUrl(HttpServletRequest request) {
        try {
            String url = request.getRequestURL().toString();
            url = new URI(url).resolve("/openapi?format=JSON").toString();
            return url;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayPrintWriter output;
        private boolean usingWriter;

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.usingWriter = false;
            this.output = new ByteArrayPrintWriter();
        }

        public byte[] getByteArray() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.usingWriter) {
                super.getOutputStream();
            }
            this.usingWriter = true;
            return this.output.getStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.usingWriter) {
                super.getWriter();
            }
            this.usingWriter = true;
            return this.output.getWriter();
        }

        public String toString() {
            return this.output.toString();
        }
    }

    private static class ByteArrayPrintWriter {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter pw = new PrintWriter(this.baos);
        private ServletOutputStream sos = new ByteArrayServletStream(this.baos);

        private ByteArrayPrintWriter() {
        }

        public PrintWriter getWriter() {
            return this.pw;
        }

        public ServletOutputStream getStream() {
            return this.sos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }

    private static class ByteArrayServletStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        ByteArrayServletStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int param) throws IOException {
            this.baos.write(param);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

