/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client;

import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.client.SearchUtil;
import io.apicurio.registry.search.client.noop.NoopSearchClient;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SearchClientFactory.class);
    public static final String SEARCH_CLIENT_CLASS = "search.client-class";
    public static final String SEARCH_CLIENT_CLASSES = "search.client-classes";
    public static final String KAFKA_CLIENT = "io.apicurio.registry.search.client.kafka.KafkaSearchClient";
    public static final String HOTROD_CLIENT = "io.apicurio.registry.search.client.hotrod.HotRodSearchClient";
    public static final String REST_CLIENT = "io.apicurio.registry.search.client.rest.RestSearchClient";
    private static final String[] CLASSES = new String[]{"io.apicurio.registry.search.client.kafka.KafkaSearchClient", "io.apicurio.registry.search.client.hotrod.HotRodSearchClient", "io.apicurio.registry.search.client.rest.RestSearchClient"};

    static SearchClient create(Properties properties) {
        String explicitClass = SearchUtil.property(properties, SEARCH_CLIENT_CLASS, null);
        if (explicitClass != null) {
            return SearchClientFactory.instantiateSearchClient(properties, explicitClass, false);
        }
        String clientClasses = SearchUtil.property(properties, SEARCH_CLIENT_CLASSES, null);
        String[] clazzes = CLASSES;
        if (clientClasses != null) {
            clazzes = clientClasses.split(",");
        }
        for (String clazz : clazzes) {
            SearchClient client = SearchClientFactory.instantiateSearchClient(properties, clazz, true);
            if (client == null) continue;
            return client;
        }
        log.info("Using '{}' search client", (Object)NoopSearchClient.class.getName());
        return new NoopSearchClient();
    }

    private static SearchClient instantiateSearchClient(Properties properties, String clazz, boolean ignoreErrors) {
        try {
            Constructor<?> ctor = SearchClient.class.getClassLoader().loadClass(clazz).getConstructor(Properties.class);
            SearchClient client = (SearchClient)ctor.newInstance(properties);
            log.info("Using '{}' search client", (Object)clazz);
            return client;
        }
        catch (Throwable t) {
            if (!ignoreErrors) {
                throw new IllegalStateException(t);
            }
            log.debug("Ignoring search client '{}' -- cannot instantiate: {}", (Object)clazz, (Object)t);
            return null;
        }
    }
}

