/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.local.ValueCacheCollection;

public class DecoratedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final long flags;
    private final Object lockOwner;
    private final CacheImpl<K, V> cacheImplementation;
    private final CacheImpl.ContextBuilder contextBuilder = this::writeContext;

    public DecoratedCache(CacheImpl<K, V> delegate, long flagsBitSet) {
        this(delegate, null, flagsBitSet);
    }

    public DecoratedCache(CacheImpl<K, V> delegate, Object lockOwner, long newFlags) {
        super(delegate);
        this.flags = newFlags;
        this.lockOwner = lockOwner;
        this.cacheImplementation = delegate;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null!");
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this.withFlags(EnumUtil.bitSetOf((Enum[])flags));
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        return this.withFlags(EnumUtil.bitSetOf(flags));
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag flag) {
        return this.withFlags(EnumUtil.bitSetOf((Enum)flag));
    }

    private AdvancedCache<K, V> withFlags(long newFlags) {
        if (EnumUtil.containsAll((long)this.flags, (long)newFlags)) {
            return this;
        }
        return new DecoratedCache<K, V>(this.cacheImplementation, this.lockOwner, EnumUtil.mergeBitSets((long)this.flags, (long)newFlags));
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        if (this.lockOwner == null) {
            return this.cacheImplementation;
        }
        return new DecoratedCache<K, V>(this.cacheImplementation, this.lockOwner, 0L);
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> encoderClass) {
        return new EncoderCache(this, this.getKeyDataConversion().withEncoding(encoderClass), this.getValueDataConversion().withEncoding(encoderClass));
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass) {
        return new EncoderCache(this, this.getKeyDataConversion().withEncoding(keyEncoderClass), this.getValueDataConversion().withEncoding(valueEncoderClass));
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapperClass) {
        return new EncoderCache(this, this.getKeyDataConversion().withWrapping(wrapperClass), this.getValueDataConversion().withWrapping(wrapperClass));
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        return new EncoderCache(this, this.getKeyDataConversion().withWrapping(keyWrapperClass), this.getValueDataConversion().withWrapping(valueWrapperClass));
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        Objects.requireNonNull(lockOwner);
        if (lockOwner != this.lockOwner) {
            return new DecoratedCache<K, V>(this.cacheImplementation, lockOwner, this.flags);
        }
        return this;
    }

    public Object getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        this.assertNoLockOwner("lockedStream");
        return super.lockedStream();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cacheImplementation.getClassLoader();
    }

    @Override
    public void stop() {
        this.cacheImplementation.stop();
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertNoLockOwner("lock");
        return this.cacheImplementation.lock((Collection<K>)Arrays.asList(keys), this.flags);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        this.assertNoLockOwner("lock");
        return this.cacheImplementation.lock(keys, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.assertNoLockOwner("putForExternalRead");
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void evict(K key) {
        this.cacheImplementation.evict(key, this.flags);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.put(key, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.putIfAbsent(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.putAll(map, metadata);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.replace(key, oldValue, value, metadata);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.put(key, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.putIfAbsent(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        this.putAll(map, metadata);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.replace(key, oldValue, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.putAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata);
    }

    private void assertNoLockOwner(String name) {
        if (this.lockOwner != null) {
            throw new IllegalStateException(name + " method cannot be used when a lock owner is configured");
        }
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.putAllAsync(data, metadata);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(data, metadata);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata) {
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return this.cacheImplementation.clearAsync(this.flags);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.cacheImplementation.removeAsync(key, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cacheImplementation.removeAsync(key, value, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<Void> removeLifespanExpired(K key, V value, Long lifespan) {
        return this.cacheImplementation.removeLifespanExpired(key, value, lifespan, this.flags);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return this.cacheImplementation.removeMaxIdleExpired(key, value, this.flags);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, (V)this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.replaceAsync(key, value, (V)metadata);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, (V)metadata);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.cacheImplementation.getAsync(key, this.flags, this.readContext(1));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cacheImplementation.getAllAsync(keys, this.flags, this.readContext(keys.size()));
    }

    @Override
    public int size() {
        return this.cacheImplementation.size(this.flags);
    }

    @Override
    public CompletableFuture<Long> sizeAsync() {
        return this.cacheImplementation.sizeAsync(this.flags);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheImplementation.isEmpty(this.flags);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheImplementation.containsKey(key, this.flags, this.readContext(1));
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    @Override
    public V get(Object key) {
        return this.cacheImplementation.get(key, this.flags, this.readContext(1));
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.cacheImplementation.getAll(keys, this.flags, this.readContext(keys.size()));
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.cacheImplementation.getAllCacheEntries(keys, this.flags, this.readContext(keys.size()));
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V remove(Object key) {
        return this.cacheImplementation.remove(key, this.flags, this.contextBuilder);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cacheImplementation.putAll(map, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public void clear() {
        this.cacheImplementation.clear(this.flags);
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cacheImplementation.keySet(this.flags);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.cacheImplementation.getGroup(groupName, this.flags);
    }

    @Override
    public void removeGroup(String groupName) {
        this.assertNoLockOwner("removeGroup");
        this.cacheImplementation.removeGroup(groupName, this.flags);
    }

    @Override
    public CacheCollection<V> values() {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet());
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cacheImplementation.entrySet(this.flags);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheImplementation.cacheEntrySet(this.flags, this.readContext(-1));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cacheImplementation.remove(key, value, this.flags, this.contextBuilder);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V replace(K key, V value) {
        return this.replace(key, value, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge(key, value, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresentAsync(key, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsync(key, mappingFunction, this.cacheImplementation.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeAsync(key, value, remappingFunction, this.cacheImplementation.defaultMetadata);
    }

    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        return this.cacheImplementation.notifier.addListenerAsync(listener, null);
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return this.cacheImplementation.notifier.addListenerAsync(listener, filter, converter);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.cacheImplementation.notifier.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.cacheImplementation.notifier.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cacheImplementation.put(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, value, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cacheImplementation.computeInternal((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, false, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cacheImplementation.computeInternal((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, true, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.cacheImplementation.computeIfAbsentInternal((K)key, mappingFunction, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cacheImplementation.mergeInternal(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, metadata, this.flags, this.contextBuilder);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        return this.cacheImplementation.getCacheEntry(key, this.flags, this.readContext(1));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return this.cacheImplementation.getCacheEntryAsync(key, this.flags, this.readContext(1));
    }

    protected InvocationContext readContext(int size) {
        InvocationContext ctx = this.cacheImplementation.invocationContextFactory.createInvocationContext(false, size);
        if (this.lockOwner != null) {
            ctx.setLockOwner(this.lockOwner);
        }
        return ctx;
    }

    protected InvocationContext writeContext(int size) {
        InvocationContext ctx = this.cacheImplementation.getInvocationContextWithImplicitTransaction(size);
        if (this.lockOwner != null) {
            ctx.setLockOwner(this.lockOwner);
        }
        return ctx;
    }
}

