/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.responses.Response;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetAllCommand<K, V>
extends BaseClusteredReadCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 46;
    private static final Log log = LogFactory.getLog(ClusteredGetAllCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<?> keys;
    private GlobalTransaction gtx;
    private InvocationContextFactory icf;
    private CommandsFactory commandsFactory;
    private AsyncInterceptorChain invoker;
    private InternalEntryFactory entryFactory;

    ClusteredGetAllCommand() {
        super(null, 0L);
    }

    public ClusteredGetAllCommand(ByteString cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetAllCommand(ByteString cacheName, List<?> keys, long flags, GlobalTransaction gtx) {
        super(cacheName, flags);
        this.keys = keys;
        this.gtx = gtx;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.commandsFactory = componentRegistry.getCommandsFactory();
        this.entryFactory = componentRegistry.getInternalEntryFactory().running();
        this.icf = componentRegistry.getInvocationContextFactory().running();
        this.invoker = componentRegistry.getInterceptorChain().running();
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (!this.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK)) {
            return this.invokeGetAll();
        }
        return this.acquireLocks().thenCompose(o -> this.invokeGetAll());
    }

    private CompletableFuture<Object> invokeGetAll() {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(this.keys, this.getFlagsBitSet(), true);
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = this.icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CompletableFuture<Object> future = this.invoker.invokeAsync(invocationContext, command);
        return future.thenApply(rv -> {
            if (trace) {
                log.trace("Found: " + rv);
            }
            if (rv == null || rv instanceof Response) {
                return rv;
            }
            Map map = (Map)rv;
            InternalCacheValue[] values = new InternalCacheValue[this.keys.size()];
            int i = 0;
            for (Object key : this.keys) {
                CacheEntry entry = (CacheEntry)map.get(key);
                InternalCacheValue value = entry == null ? null : (entry instanceof InternalCacheEntry ? ((InternalCacheEntry)entry).toInternalCacheValue() : this.entryFactory.createValue(entry));
                values[i++] = value;
            }
            return values;
        });
    }

    private CompletableFuture<Object> acquireLocks() throws Throwable {
        LockControlCommand lockControlCommand = this.commandsFactory.buildLockControlCommand(this.keys, this.getFlagsBitSet(), this.gtx);
        this.commandsFactory.initializeReplicableCommand(lockControlCommand, false);
        return lockControlCommand.invokeAsync();
    }

    public List<?> getKeys() {
        return this.keys;
    }

    @Override
    public byte getCommandId() {
        return 46;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.gtx);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.setFlagsBitSet(input.readLong());
        this.gtx = (GlobalTransaction)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ClusteredGetAllCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", flags=").append(this.printFlags());
        sb.append(", topologyId=").append(this.topologyId);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusteredGetAllCommand other = (ClusteredGetAllCommand)obj;
        if (this.gtx == null ? other.gtx != null : !this.gtx.equals(other.gtx)) {
            return false;
        }
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gtx == null ? 0 : this.gtx.hashCode());
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }
}

