/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.expiration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class RetrieveLastAccessCommand
extends BaseRpcCommand
implements InitializableCommand,
TopologyAffectedCommand,
SegmentSpecificCommand {
    private Object key;
    private Object value;
    private InternalDataContainer<Object, Object> container;
    private TimeService timeService;
    private int topologyId = -1;
    private int segment;
    public static final byte COMMAND_ID = 81;

    private RetrieveLastAccessCommand() {
        this(null);
    }

    public RetrieveLastAccessCommand(ByteString cacheName) {
        super(cacheName);
        this.segment = -1;
    }

    public RetrieveLastAccessCommand(ByteString cacheName, Object key, Object value, int segment) {
        super(cacheName);
        this.key = Objects.requireNonNull(key);
        this.value = value;
        this.segment = segment;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.container = componentRegistry.getInternalDataContainer().running();
        this.timeService = componentRegistry.getTimeService();
    }

    @Override
    public byte getCommandId() {
        return 81;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        if (this.value == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeObject(this.value);
        }
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        boolean hasValue = input.readBoolean();
        if (hasValue) {
            this.value = input.readObject();
        }
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        InternalCacheEntry<Object, Object> ice = this.container.peek(this.segment, this.key);
        if (ice != null && (this.value == null || this.value.equals(ice.getValue())) && !ice.isExpired(this.timeService.wallClockTime())) {
            return CompletableFuture.completedFuture(ice.getLastUsed());
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public int getSegment() {
        return this.segment;
    }
}

