/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;

public class VersionedCommitCommand
extends CommitCommand {
    public static final byte COMMAND_ID = 27;
    private EntryVersionsMap updatedVersions;

    public VersionedCommitCommand() {
        super(null);
    }

    public VersionedCommitCommand(ByteString cacheName, GlobalTransaction gtx) {
        super(cacheName, gtx);
    }

    public VersionedCommitCommand(ByteString cacheName) {
        super(cacheName);
    }

    public EntryVersionsMap getUpdatedVersions() {
        return this.updatedVersions;
    }

    public void setUpdatedVersions(EntryVersionsMap updatedVersions) {
        this.updatedVersions = updatedVersions;
    }

    @Override
    public byte getCommandId() {
        return 27;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallMap((Map)this.updatedVersions, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.updatedVersions = (EntryVersionsMap)MarshallUtil.unmarshallMap((ObjectInput)input, EntryVersionsMap::new);
    }

    @Override
    public String toString() {
        return "VersionedCommitCommand{gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + ", topologyId=" + this.getTopologyId() + ", updatedVersions=" + this.updatedVersions + '}';
    }
}

