/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractPersistenceConfigurationChildBuilder;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.logging.Log;

public abstract class AbstractStoreConfigurationBuilder<T extends StoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractPersistenceConfigurationChildBuilder
implements StoreConfigurationBuilder<T, S>,
ConfigurationBuilderInfo {
    protected final AttributeSet attributes;
    protected final AsyncStoreConfigurationBuilder<S> async;
    private final List<ConfigurationBuilderInfo> subElements = new ArrayList<ConfigurationBuilderInfo>();

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this);
        this.subElements.add(this.async);
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    public S fetchPersistentState(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.IGNORE_MODIFICATIONS).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public S properties(Properties properties) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)new TypedProperties(properties));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)properties);
        XmlConfigHelper.setAttributes(this.attributes, properties, false, false);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S withProperties(Properties props) {
        XmlConfigHelper.showUnrecognizedAttributes(XmlConfigHelper.setAttributes(this.attributes, props, false, false));
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)new TypedProperties(props));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S preload(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S shared(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SHARED).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S transactional(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S maxBatchSize(int maxBatchSize) {
        this.attributes.attribute(AbstractStoreConfiguration.MAX_BATCH_SIZE).set((Object)maxBatchSize);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S segmented(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        this.validate(false);
    }

    protected void validate(boolean skipClassChecks) {
        if (!skipClassChecks) {
            this.validateStoreWithAnnotations();
        }
        this.validateStoreAttributes();
    }

    private void validateStoreAttributes() {
        this.async.validate();
        boolean shared = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.SHARED).get();
        boolean fetchPersistentState = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).get();
        boolean purgeOnStartup = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).get();
        boolean preload = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).get();
        boolean transactional = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).get();
        ConfigurationBuilder builder = this.getBuilder();
        if (!(shared || fetchPersistentState || purgeOnStartup || !builder.clustering().cacheMode().isClustered() || this.getBuilder().template())) {
            Log.CONFIG.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
        }
        if (fetchPersistentState && this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).isModified() && this.clustering().cacheMode().isInvalidation()) {
            throw Log.CONFIG.attributeNotAllowedInInvalidationMode(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE.name());
        }
        if (shared) {
            if (!builder.clustering().cacheMode().isClustered()) {
                throw Log.CONFIG.sharedStoreWithLocalCache();
            }
            if (!preload && builder.indexing().enabled() && builder.indexing().indexLocalOnly() && !this.getBuilder().template()) {
                Log.CONFIG.localIndexingWithSharedCacheLoaderRequiresPreload();
            }
        }
        if (transactional && !builder.transaction().transactionMode().isTransactional()) {
            throw Log.CONFIG.transactionalStoreInNonTransactionalCache();
        }
        if (transactional && builder.persistence().passivation()) {
            throw Log.CONFIG.transactionalStoreInPassivatedCache();
        }
    }

    private void validateStoreWithAnnotations() {
        Class configKlass = this.attributes.getKlass();
        if (configKlass != null && configKlass.isAnnotationPresent(ConfigurationFor.class)) {
            Class storeKlass = configKlass.getAnnotation(ConfigurationFor.class).value();
            if (storeKlass.isAnnotationPresent(Store.class)) {
                Store storeProps = storeKlass.getAnnotation(Store.class);
                boolean segmented = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).get();
                if (segmented && !SegmentedAdvancedLoadWriteStore.class.isAssignableFrom(storeKlass) && !AbstractSegmentedStoreConfiguration.class.isAssignableFrom(configKlass)) {
                    throw Log.CONFIG.storeNotSegmented(storeKlass);
                }
                if (!storeProps.shared() && ((Boolean)this.attributes.attribute(AbstractStoreConfiguration.SHARED).get()).booleanValue()) {
                    throw Log.CONFIG.nonSharedStoreConfiguredAsShared(storeKlass.getSimpleName());
                }
            } else {
                Log.CONFIG.warnStoreAnnotationMissing(storeKlass.getSimpleName());
            }
        } else {
            Log.CONFIG.warnConfigurationForAnnotationMissing(this.attributes.getName());
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public Builder<?> read(T template) {
        Method attributesMethod = ReflectionUtil.findMethod(template.getClass(), (String)"attributes");
        try {
            this.attributes.read((AttributeSet)attributesMethod.invoke(template, null));
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
        this.async.read(template.async());
        return this;
    }

    public String toString() {
        return "AbstractStoreConfigurationBuilder [attributes=" + this.attributes + ", async=" + this.async + "]";
    }
}

