/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;

public class ClusterLoaderConfigurationBuilder
extends AbstractStoreConfigurationBuilder<ClusterLoaderConfiguration, ClusterLoaderConfigurationBuilder>
implements ConfigurationBuilderInfo {
    public ClusterLoaderConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, ClusterLoaderConfiguration.attributeDefinitionSet());
    }

    public ClusterLoaderConfigurationBuilder self() {
        return this;
    }

    public ClusterLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout) {
        this.attributes.attribute(ClusterLoaderConfiguration.REMOTE_CALL_TIMEOUT).set((Object)remoteCallTimeout);
        return this;
    }

    public ElementDefinition getElementDefinition() {
        return ClusterLoaderConfiguration.ELEMENT_DEFINITION;
    }

    public ClusterLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout, TimeUnit unit) {
        this.remoteCallTimeout(unit.toMillis(remoteCallTimeout));
        return this;
    }

    @Override
    public ClusterLoaderConfigurationBuilder withProperties(Properties p) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)p));
        XmlConfigHelper.setAttributes(this.attributes, p, false, true);
        return this;
    }

    @Override
    public void validate() {
    }

    public ClusterLoaderConfiguration create() {
        return new ClusterLoaderConfiguration(this.attributes.protect(), this.async.create());
    }

    public ClusterLoaderConfigurationBuilder read(ClusterLoaderConfiguration template) {
        super.read(template);
        return this;
    }
}

