/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.cache.UnsafeConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class ConfigurationBuilder
implements ConfigurationChildBuilder,
ConfigurationBuilderInfo {
    private final ClusteringConfigurationBuilder clustering;
    private final CustomInterceptorsConfigurationBuilder customInterceptors;
    private final EncodingConfigurationBuilder encoding;
    private final ExpirationConfigurationBuilder expiration;
    private final IndexingConfigurationBuilder indexing;
    private final InvocationBatchingConfigurationBuilder invocationBatching;
    private final JMXStatisticsConfigurationBuilder jmxStatistics;
    private final PersistenceConfigurationBuilder persistence;
    private final LockingConfigurationBuilder locking;
    private final SecurityConfigurationBuilder security;
    private final TransactionConfigurationBuilder transaction;
    private final UnsafeConfigurationBuilder unsafe;
    private final List<Builder<?>> modules = new ArrayList();
    private final SitesConfigurationBuilder sites;
    private final MemoryConfigurationBuilder memory;
    private final AttributeSet attributes;
    private boolean template = false;
    private List<ConfigurationBuilderInfo> subElements = new ArrayList<ConfigurationBuilderInfo>();

    public ElementDefinition<? extends ConfigurationInfo> getElementDefinition() {
        return Configuration.ELEMENT_DEFINITION;
    }

    public ConfigurationBuilder() {
        this.attributes = Configuration.attributeDefinitionSet();
        this.clustering = new ClusteringConfigurationBuilder(this);
        this.customInterceptors = new CustomInterceptorsConfigurationBuilder(this);
        this.encoding = new EncodingConfigurationBuilder(this);
        this.expiration = new ExpirationConfigurationBuilder(this);
        this.indexing = new IndexingConfigurationBuilder(this);
        this.invocationBatching = new InvocationBatchingConfigurationBuilder(this);
        this.jmxStatistics = new JMXStatisticsConfigurationBuilder(this);
        this.persistence = new PersistenceConfigurationBuilder(this);
        this.locking = new LockingConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.transaction = new TransactionConfigurationBuilder(this);
        this.unsafe = new UnsafeConfigurationBuilder(this);
        this.sites = new SitesConfigurationBuilder(this);
        this.memory = new MemoryConfigurationBuilder(this);
        this.subElements.addAll(Arrays.asList(this.clustering, this.persistence, this.unsafe, this.jmxStatistics, this.locking, this.indexing, this.expiration, this.encoding, this.memory, this.transaction, this.sites, this.customInterceptors, this.security, this.sites.backupFor()));
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    @Override
    public ConfigurationBuilder simpleCache(boolean simpleCache) {
        this.attributes.attribute(Configuration.SIMPLE_CACHE).set((Object)simpleCache);
        return this;
    }

    @Override
    public boolean simpleCache() {
        return (Boolean)this.attributes.attribute(Configuration.SIMPLE_CACHE).get();
    }

    @Override
    public ClusteringConfigurationBuilder clustering() {
        return this.clustering;
    }

    @Override
    @Deprecated
    public CustomInterceptorsConfigurationBuilder customInterceptors() {
        return this.customInterceptors;
    }

    @Override
    public EncodingConfigurationBuilder encoding() {
        return this.encoding;
    }

    @Override
    public ExpirationConfigurationBuilder expiration() {
        return this.expiration;
    }

    @Override
    public IndexingConfigurationBuilder indexing() {
        return this.indexing;
    }

    @Override
    public InvocationBatchingConfigurationBuilder invocationBatching() {
        return this.invocationBatching;
    }

    @Override
    public JMXStatisticsConfigurationBuilder jmxStatistics() {
        return this.jmxStatistics;
    }

    @Override
    public PersistenceConfigurationBuilder persistence() {
        return this.persistence;
    }

    @Override
    public LockingConfigurationBuilder locking() {
        return this.locking;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public UnsafeConfigurationBuilder unsafe() {
        return this.unsafe;
    }

    @Override
    public SitesConfigurationBuilder sites() {
        return this.sites;
    }

    @Override
    public MemoryConfigurationBuilder memory() {
        return this.memory;
    }

    public List<Builder<?>> modules() {
        return Collections.unmodifiableList(this.modules);
    }

    public ConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(ConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            this.modules.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public ConfigurationBuilder template(boolean template) {
        this.template = template;
        return this;
    }

    public boolean template() {
        return this.template;
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(Configuration.SIMPLE_CACHE).get()).booleanValue()) {
            this.validateSimpleCacheConfiguration();
        }
        ArrayList<RuntimeException> validationExceptions = new ArrayList<RuntimeException>();
        for (Builder builder : Arrays.asList(this.clustering, this.customInterceptors, this.expiration, this.indexing, this.invocationBatching, this.jmxStatistics, this.persistence, this.locking, this.transaction, this.unsafe, this.sites, this.memory)) {
            try {
                builder.validate();
            }
            catch (RuntimeException e2) {
                validationExceptions.add(e2);
            }
        }
        for (Builder builder : this.modules) {
            try {
                builder.validate();
            }
            catch (RuntimeException e3) {
                validationExceptions.add(e3);
            }
        }
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    private void validateSimpleCacheConfiguration() {
        if (this.clustering().cacheMode().isClustered() || this.transaction.transactionMode() != null && this.transaction.transactionMode().isTransactional() || !this.customInterceptors.create().interceptors().isEmpty() || !this.persistence.stores().isEmpty() || this.invocationBatching.isEnabled() || this.indexing.enabled() || this.memory.create().storageType() == StorageType.BINARY) {
            throw Log.CONFIG.notSupportedInSimpleCache();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        ArrayList<RuntimeException> validationExceptions = new ArrayList<RuntimeException>();
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.clustering, this.customInterceptors, this.expiration, this.indexing, this.invocationBatching, this.jmxStatistics, this.persistence, this.locking, this.transaction, this.unsafe, this.sites, this.security, this.memory)) {
            try {
                configurationChildBuilder.validate(globalConfig);
            }
            catch (RuntimeException e2) {
                validationExceptions.add(e2);
            }
        }
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    @Override
    public Configuration build() {
        return this.build(true);
    }

    public Configuration build(GlobalConfiguration globalConfiguration) {
        this.validate(globalConfiguration);
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        LinkedList<Object> modulesConfig = new LinkedList<Object>();
        for (Builder<?> module : this.modules) {
            modulesConfig.add(module.create());
        }
        return new Configuration(this.template, this.attributes.protect(), this.clustering.create(), this.customInterceptors.create(), this.expiration.create(), this.encoding.create(), this.indexing.create(), this.invocationBatching.create(), this.jmxStatistics.create(), this.persistence.create(), this.locking.create(), this.security.create(), this.transaction.create(), this.unsafe.create(), this.sites.create(), this.memory.create(), modulesConfig);
    }

    public ConfigurationBuilder read(Configuration template) {
        this.attributes.read(template.attributes());
        this.clustering.read(template.clustering());
        this.customInterceptors.read(template.customInterceptors());
        this.expiration.read(template.expiration());
        this.indexing.read(template.indexing());
        this.invocationBatching.read(template.invocationBatching());
        this.jmxStatistics.read(template.jmxStatistics());
        this.persistence.read(template.persistence());
        this.locking.read(template.locking());
        this.security.read(template.security());
        this.transaction.read(template.transaction());
        this.unsafe.read(template.unsafe());
        this.sites.read(template.sites());
        this.memory.read(template.memory());
        this.encoding.read(template.encoding());
        this.template = template.isTemplate();
        for (Object c : template.modules().values()) {
            Object builder = this.addModule(ConfigurationUtils.builderFor(c));
            builder.read(c);
        }
        return this;
    }

    public String toString() {
        return "ConfigurationBuilder{clustering=" + this.clustering + ", customInterceptors=" + this.customInterceptors + ", expiration=" + this.expiration + ", indexing=" + this.indexing + ", invocationBatching=" + this.invocationBatching + ", jmxStatistics=" + this.jmxStatistics + ", persistence=" + this.persistence + ", locking=" + this.locking + ", modules=" + this.modules + ", security=" + this.security + ", transaction=" + this.transaction + ", unsafe=" + this.unsafe + ", sites=" + this.sites + '}';
    }
}

