/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class JMXStatisticsConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<JMXStatisticsConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = JMXStatisticsConfiguration.attributeDefinitionSet();

    JMXStatisticsConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return JMXStatisticsConfiguration.ELEMENT_DEFINITION;
    }

    public JMXStatisticsConfigurationBuilder enable() {
        this.attributes.attribute(JMXStatisticsConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public JMXStatisticsConfigurationBuilder disable() {
        this.attributes.attribute(JMXStatisticsConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public JMXStatisticsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(JMXStatisticsConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public JMXStatisticsConfigurationBuilder available(boolean available) {
        this.attributes.attribute(JMXStatisticsConfiguration.AVAILABLE).set((Object)available);
        return this;
    }

    public void validate() {
        Attribute enabled = this.attributes.attribute(JMXStatisticsConfiguration.ENABLED);
        Attribute available = this.attributes.attribute(JMXStatisticsConfiguration.AVAILABLE);
        if (enabled.isModified() && available.isModified() && ((Boolean)enabled.get()).booleanValue() && !((Boolean)available.get()).booleanValue()) {
            throw Log.CONFIG.statisticsEnabledNotAvailable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public JMXStatisticsConfiguration create() {
        return new JMXStatisticsConfiguration(this.attributes.protect());
    }

    public JMXStatisticsConfigurationBuilder read(JMXStatisticsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "JMXStatisticsConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

