/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;

public class MemoryStorageConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Long> SIZE = AttributeDefinition.builder((String)"size", (Object)-1L).build();
    public static final AttributeDefinition<EvictionType> EVICTION_TYPE = AttributeDefinition.builder((String)"type", (Object)((Object)EvictionType.COUNT)).xmlName(Attribute.EVICTION.getLocalName()).build();
    public static final AttributeDefinition<EvictionStrategy> EVICTION_STRATEGY = AttributeDefinition.builder((String)"strategy", (Object)((Object)EvictionStrategy.NONE)).build();
    public static final AttributeDefinition<Integer> ADDRESS_COUNT = AttributeDefinition.builder((String)"address-count", (Object)0x100000).build();
    private final AttributeSet attributes;
    private final StorageType storageType;
    private final ElementDefinition elementDefinition;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemoryStorageConfiguration.class, new AttributeDefinition[]{SIZE, EVICTION_TYPE, EVICTION_STRATEGY, ADDRESS_COUNT});
    }

    public MemoryStorageConfiguration(AttributeSet attributes, StorageType storageType) {
        this.attributes = attributes;
        this.storageType = storageType;
        String storage = storageType == null ? StorageType.OBJECT.getElement().getLocalName() : storageType.getElement().getLocalName();
        this.elementDefinition = new DefaultElementDefinition(storage);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return this.elementDefinition;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public long size() {
        return (Long)this.attributes.attribute(SIZE).get();
    }

    public EvictionType evictionType() {
        return (EvictionType)((Object)this.attributes.attribute(EVICTION_TYPE).get());
    }

    public EvictionStrategy evictionStrategy() {
        return (EvictionStrategy)((Object)this.attributes.attribute(EVICTION_STRATEGY).get());
    }

    @Deprecated
    public int addressCount() {
        return (Integer)this.attributes.attribute(ADDRESS_COUNT).get();
    }

    public void size(long newSize) {
        this.attributes.attribute(SIZE).set((Object)newSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryStorageConfiguration that = (MemoryStorageConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "MemoryStorageConfiguration{attributes=" + this.attributes + ", storageType=" + (Object)((Object)this.storageType) + '}';
    }
}

