/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.GlobalStorageConfiguration;
import org.infinispan.configuration.global.TemporaryGlobalStatePathConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;

public class GlobalStateConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.GLOBAL_STATE.getLocalName());
    private final AttributeSet attributes;
    private final Attribute<Boolean> enabled;
    private final GlobalStatePathConfiguration persistenceLocationConfiguration;
    private final GlobalStatePathConfiguration sharedPersistenceLocationConfiguration;
    private final TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration;
    private final GlobalStorageConfiguration globalStorageConfiguration;
    private final List<ConfigurationInfo> subElements = new ArrayList<ConfigurationInfo>();

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{ENABLED});
    }

    public GlobalStateConfiguration(AttributeSet attributes, GlobalStatePathConfiguration persistenceLocationConfiguration, GlobalStatePathConfiguration sharedPersistenceLocationConfiguration, TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration, GlobalStorageConfiguration globalStorageConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.persistenceLocationConfiguration = persistenceLocationConfiguration;
        this.sharedPersistenceLocationConfiguration = sharedPersistenceLocationConfiguration;
        this.temporaryLocationConfiguration = temporaryLocationConfiguration;
        this.globalStorageConfiguration = globalStorageConfiguration;
        this.subElements.addAll(Arrays.asList(persistenceLocationConfiguration, sharedPersistenceLocationConfiguration, temporaryLocationConfiguration, globalStorageConfiguration));
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public String persistentLocation() {
        return this.persistenceLocationConfiguration.getLocation();
    }

    public GlobalStatePathConfiguration persistenceConfiguration() {
        return this.persistenceLocationConfiguration;
    }

    public String sharedPersistentLocation() {
        return this.sharedPersistenceLocationConfiguration.getLocation();
    }

    public GlobalStatePathConfiguration sharedPersistenceConfiguration() {
        return this.sharedPersistenceLocationConfiguration;
    }

    public String temporaryLocation() {
        return this.temporaryLocationConfiguration.getLocation();
    }

    public TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration() {
        return this.temporaryLocationConfiguration;
    }

    public ConfigurationStorage configurationStorage() {
        return this.globalStorageConfiguration.configurationStorage();
    }

    public GlobalStorageConfiguration globalStorageConfiguration() {
        return this.globalStorageConfiguration;
    }

    public Supplier<? extends LocalConfigurationStorage> configurationStorageClass() {
        return this.globalStorageConfiguration.storageSupplier();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + this.attributes + "]";
    }
}

