/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.DefaultThreadFactory;

public class ScheduledThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<ScheduledThreadPoolConfiguration>,
ThreadPoolBuilderAdapter {
    private final AttributeSet attributes = ScheduledThreadPoolConfiguration.attributeDefinitionSet();

    ScheduledThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(ScheduledThreadPoolConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ScheduledThreadPoolConfigurationBuilder threadFactory(String threadFactory) {
        this.attributes.attribute(ScheduledThreadPoolConfiguration.THREAD_FACTORY).set((Object)threadFactory);
        return this;
    }

    public String threadFactory() {
        return (String)this.attributes.attribute(ScheduledThreadPoolConfiguration.THREAD_FACTORY).get();
    }

    public void validate() {
    }

    public ScheduledThreadPoolConfiguration create() {
        return new ScheduledThreadPoolConfiguration(this.attributes.protect());
    }

    public ScheduledThreadPoolConfigurationBuilder read(ScheduledThreadPoolConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "ScheduledThreadPoolConfigurationBuilder{attributes=" + this.attributes + '}';
    }

    @Override
    public ThreadPoolConfiguration asThreadPoolConfigurationBuilder() {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(this.getGlobalConfig());
        builder.threadPoolFactory((ThreadPoolExecutorFactory)ScheduledThreadPoolExecutorFactory.create());
        DefaultThreadFactory threadFactory = this.getGlobalConfig().threads().getThreadFactory(this.threadFactory()).create().getThreadFactory();
        builder.threadFactory(threadFactory);
        return builder.create();
    }
}

