/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.factories.threads.DefaultThreadFactory;

class ThreadFactoryConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    static final AttributeDefinition<ThreadGroup> GROUP = AttributeDefinition.builder((String)"groupName", null, ThreadGroup.class).serializer((AttributeSerializer)new AttributeSerializer<ThreadGroup, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object getSerializationValue(Attribute<ThreadGroup> attribute, ConfigurationInfo configurationElement) {
            return ((ThreadGroup)attribute.get()).getName();
        }
    }).build();
    static final AttributeDefinition<String> THREAD_NAME_PATTERN = AttributeDefinition.builder((String)"threadNamePattern", null, String.class).build();
    static final AttributeDefinition<Integer> PRIORITY = AttributeDefinition.builder((String)"priority", null, Integer.class).build();
    private final AttributeSet attributes;
    private final Attribute<String> name;
    private final Attribute<ThreadGroup> group;
    private final Attribute<String> threadNamePattern;
    private final Attribute<Integer> priority;
    private final DefaultThreadFactory threadFactory;
    private String nodeName;
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.THREAD_FACTORY.getLocalName());

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ThreadFactoryConfiguration.class, new AttributeDefinition[]{NAME, GROUP, THREAD_NAME_PATTERN, PRIORITY});
    }

    ThreadFactoryConfiguration(AttributeSet attributes, String nodeName) {
        this.attributes = attributes.checkProtection();
        this.name = attributes.attribute(NAME);
        this.group = attributes.attribute(GROUP);
        this.threadNamePattern = attributes.attribute(THREAD_NAME_PATTERN);
        this.priority = attributes.attribute(PRIORITY);
        this.nodeName = nodeName;
        this.threadFactory = new DefaultThreadFactory((String)this.name.get(), (ThreadGroup)this.group.get(), (Integer)this.priority.get(), (String)this.threadNamePattern.get(), nodeName, null);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public DefaultThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Attribute<String> name() {
        return this.name;
    }

    public Attribute<ThreadGroup> groupName() {
        return this.group;
    }

    public Attribute<String> threadPattern() {
        return this.threadNamePattern;
    }

    public Attribute<Integer> priority() {
        return this.priority;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String toString() {
        return "ThreadFactoryConfiguration{attributes=" + this.attributes + ", nodeName='" + this.nodeName + '\'' + '}';
    }
}

